% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotLearnerPrediction.R
\name{plotLearnerPrediction}
\alias{plotLearnerPrediction}
\title{Visualizes a learning algorithm on a 1D or 2D data set.}
\usage{
plotLearnerPrediction(learner, task, features = NULL, measures, cv = 10L,
  ..., gridsize, pointsize = 2, prob.alpha = TRUE, se.band = TRUE,
  err.mark = "train", bg.cols = c("darkblue", "green", "darkred"),
  err.col = "white", err.size = pointsize, greyscale = FALSE)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{task}{[\code{\link{Task}}]\cr
The task.}

\item{features}{[\code{character}]\cr
Selected features for model.
By default the first 2 features are used.}

\item{measures}{[\code{\link{Measure}} | list of \code{\link{Measure}}]\cr
Performance measure(s) to evaluate.}

\item{cv}{[\code{integer(1)}]\cr
Do cross-validation and display in plot title?
Number of folds. 0 means no CV.
Default is 10.}

\item{...}{[any]\cr
Parameters for \code{learner}.}

\item{gridsize}{[\code{integer(1)}]\cr
Grid resolution per axis for background predictions.
Default is 500 for 1D and 100 for 2D.}

\item{pointsize}{[\code{numeric(1)}]\cr
Pointsize for ggplot2 \code{\link[ggplot2]{geom_point}} for data points.
Default is 2.}

\item{prob.alpha}{[\code{logical(1)}]\cr
For classification: Set alpha value of background to probability for
predicted class? Allows visualization of \dQuote{confidence} for prediction.
If not, only a constant color is displayed in the background for the predicted label.
Default is \code{TRUE}.}

\item{se.band}{[\code{logical(1)}]\cr
For regression in 1D: Show band for standard error estimation?
Default is \code{TRUE}.}

\item{err.mark}{[\code{character(1)}]:
For classification: Either mark error of the model on the training data (\dQuote{train}) or
during cross-validation (\dQuote{cv}) or not at all with \dQuote{none}.
Default is \dQuote{train}.}

\item{bg.cols}{[\code{character(3)}]\cr
Background colors for classification and regression.
Sorted from low, medium to high.
Default is \code{TRUE}.}

\item{err.col}{[\code{character(1)}]\cr
For classification: Color of misclassified data points.
Default is \dQuote{white}}

\item{err.size}{[\code{integer(1)}]\cr
For classification: Size of of misclassified data points.
Default is \code{pointsize}.}

\item{greyscale}{[\code{logical(1)}]\cr
Should the plot be greyscale completely?
Default is \code{FALSE}.}
}
\value{
The ggplot2 object.
}
\description{
Trains the model for 1 or 2 selected features, then displays it via \code{\link[ggplot2]{ggplot}}.
Good for teaching or exploring models.

For classification and clustering, only 2D plots are supported. The data points, the classification and
potentially through color alpha blending the posterior probabilities are shown.

For regression, 1D and 2D plots are supported. 1D shows the data, the estimated mean and potentially
the estimated standard error. 2D does not show estimated standard error,
but only the estimated mean via background color.

The plot title displays the model id, its parameters, the training performance
and the cross-validation performance.
}

