% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getHyperPars.R
\name{getHyperPars}
\alias{getHyperPars}
\title{Get current parameter settings for a learner.}
\usage{
getHyperPars(learner, for.fun = c("train", "predict", "both"))
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{for.fun}{[\code{character(1)}]\cr
Restrict the returned settings to hyperparameters corresponding to \code{when}
the are used (see \code{\link[ParamHelpers]{LearnerParam}}).
Must be a subset of: \dQuote{train}, \dQuote{predict} or \dQuote{both}.
Default is \code{c("train", "predict", "both")}.}
}
\value{
[\code{list}]. A named list of values.
}
\description{
Get current parameter settings for a learner.
}
\seealso{
Other learner: \code{\link{LearnerProperties}},
  \code{\link{addProperties}}, \code{\link{hasProperties}},
  \code{\link{removeProperties}},
  \code{\link{setProperties}}; \code{\link{Learner}},
  \code{\link{makeLearner}}; \code{\link{getParamSet}};
  \code{\link{removeHyperPars}};
  \code{\link{setHyperPars}}; \code{\link{setId}};
  \code{\link{setPredictThreshold}};
  \code{\link{setPredictType}}; \code{\link{showHyperPars}}
}

