% Generated by roxygen2 (4.0.2): do not edit by hand
\name{makeFilterWrapper}
\alias{makeFilterWrapper}
\title{Fuse learner with a feature filter method.}
\usage{
makeFilterWrapper(learner, fw.method = "rf.importance", fw.perc = NULL,
  fw.abs = NULL, fw.threshold = NULL, ...)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{fw.method}{[\code{character(1)}]\cr
Filter method. See \code{\link{listFilterMethods}}.
Default is \dQuote{rf.importance}.}

\item{fw.perc}{[\code{numeric(1)}]\cr
If set, select \code{fw.perc}*100 top scoring features.
Mutually exclusive with arguments \code{fw.abs} and \code{fw.threshold}.}

\item{fw.abs}{[\code{numeric(1)}]\cr
If set, select \code{fw.abs} top scoring features.
Mutually exclusive with arguments \code{fw.perc} and \code{fw.threshold}.}

\item{fw.threshold}{[\code{numeric(1)}]\cr
If set, select features whose score exceeds \code{fw.threshold}.
Mutually exclusive with arguments \code{fw.perc} and \code{fw.abs}.}

\item{...}{[any]\cr
Additional parameters passed down to the filter.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Fuses a base learner with a filter method. Creates a learner object, which can be
used like any other learner object.
Internally uses \code{\link{filterFeatures}} before every model fit.

After training, the selected features can be retrieved with
\code{\link{getFilteredFeatures}}.

Note that observation weights do not influence the filtering and are simply passed
down to the next learner.
}
\examples{
task = makeClassifTask(data = iris, target = "Species")
lrn = makeLearner("classif.lda")
inner = makeResampleDesc("Holdout")
outer = makeResampleDesc("CV", iters = 2)
lrn = makeFilterWrapper(lrn, fw.perc = 0.5)
mod = train(lrn, task)
print(getFilteredFeatures(mod))
# now nested resampling, where we extract the features that the filter method selected
r = resample(lrn, task, outer, extract = function(model) {
  getFilteredFeatures(model)
})
print(r$extract)
}
\seealso{
Other filter: \code{\link{FilterValues}};
  \code{\link{filterFeatures}};
  \code{\link{getFilterValues}};
  \code{\link{getFilteredFeatures}}

Other wrapper: \code{\link{CostSensClassifModel}},
  \code{\link{CostSensClassifWrapper}},
  \code{\link{makeCostSensClassifWrapper}};
  \code{\link{CostSensRegrModel}},
  \code{\link{CostSensRegrWrapper}},
  \code{\link{makeCostSensRegrWrapper}};
  \code{\link{makeBaggingWrapper}};
  \code{\link{makeDownsampleWrapper}};
  \code{\link{makeFeatSelWrapper}};
  \code{\link{makeImputeWrapper}};
  \code{\link{makeMulticlassWrapper}};
  \code{\link{makeOverBaggingWrapper}};
  \code{\link{makeOversampleWrapper}},
  \code{\link{makeUndersampleWrapper}};
  \code{\link{makePreprocWrapper}};
  \code{\link{makeSMOTEWrapper}};
  \code{\link{makeTuneWrapper}};
  \code{\link{makeWeightedClassesWrapper}}
}

