% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvTask.R
\name{makeSurvTask}
\alias{makeSurvTask}
\alias{SurvTask}
\title{Create a survival task.}
\usage{
makeSurvTask(id = deparse(substitute(data)), data, target,
  weights = NULL, blocking = NULL, coordinates = NULL,
  fixup.data = "warn", check.data = TRUE)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Id string for object.
Default is the name of the R variable passed to \code{data}.}

\item{data}{(\link{data.frame})\cr
A data frame containing the features and target variable(s).}

\item{target}{(\code{character(1)} | \code{character(2)} | \code{character(n.classes)})\cr
Name(s) of the target variable(s).
For survival analysis these are the names of the survival time and event columns,
so it has length 2. For multilabel classification it contains the names of the logical
columns that encode whether a label is present or not and its length corresponds to the
number of classes.}

\item{weights}{(\link{numeric})\cr
Optional, non-negative case weight vector to be used during fitting.
Cannot be set for cost-sensitive learning.
Default is \code{NULL} which means no (= equal) weights.}

\item{blocking}{(\link{factor})\cr
An optional factor of the same length as the number of observations.
Observations with the same blocking level \dQuote{belong together}.
Specifically, they are either put all in the training or the test set
during a resampling iteration.
Default is \code{NULL} which means no blocking.}

\item{coordinates}{(\link{data.frame})\cr
Coordinates of a spatial data set that will be used for spatial partitioning of the data in a spatial cross-validation resampling setting.
Coordinates have to be numeric values.
Provided \link{data.frame} needs to have the same number of rows as data and consist of at least two dimensions.}

\item{fixup.data}{(\code{character(1)})\cr
Should some basic cleaning up of data be performed?
Currently this means removing empty factor levels for the columns.
Possible choices are:
\dQuote{no} = Don't do it.
\dQuote{warn} = Do it but warn about it.
\dQuote{quiet} = Do it but keep silent.
Default is \dQuote{warn}.}

\item{check.data}{(\code{logical(1)})\cr
Should sanity of data be checked initially at task creation?
You should have good reasons to turn this off (one might be speed).
Default is \code{TRUE}.}
}
\description{
Create a survival task.
}
\seealso{
\link{Task} \link{ClassifTask} \link{ClusterTask} \link{CostSensTask} \link{MultilabelTask} \link{RegrTask}
}
