% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBMRBoxplots.R
\name{plotBMRBoxplots}
\alias{plotBMRBoxplots}
\title{Create box or violin plots for a BenchmarkResult.}
\usage{
plotBMRBoxplots(bmr, measure = NULL, style = "box", order.lrns = NULL,
  order.tsks = NULL, pretty.names = TRUE, facet.wrap.nrow = NULL,
  facet.wrap.ncol = NULL)
}
\arguments{
\item{bmr}{[\code{\link{BenchmarkResult}}]\cr
Benchmark result.}

\item{measure}{[\code{\link{Measure}}]\cr
Performance measure.
Default is the first measure used in the benchmark experiment.}

\item{style}{[\code{character(1)}]\cr
Type of plot, can be \dQuote{box} for a boxplot or \dQuote{violin} for a violin plot.
Default is \dQuote{box}.}

\item{order.lrns}{[\code{character(n.learners)}]\cr 
Character vector with \code{learner.ids} in new order.}

\item{order.tsks}{[\code{character(n.tasks)}] \cr 
Character vector with \code{task.ids} in new order.}

\item{pretty.names}{[\code{logical(1)}]\cr
Whether to use the \code{\link{Measure}} name and the \code{\link{Learner}}
short name instead of the id. Default is \code{TRUE}.}

\item{facet.wrap.nrow, facet.wrap.ncol}{[\code{integer()}]\cr
Number of rows and columns for facetting. Default for both is \code{NULL}.
In this case ggplot's \code{facet_wrap} will choose the layout itself.}
}
\value{
ggplot2 plot object.
}
\description{
Plots box or violin plots for a selected \code{measure} across all iterations
of the resampling strategy, faceted by the \code{task.id}.
}
\examples{
# see benchmark
}
\seealso{
Other plot: \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialDependenceGGVIS}},
  \code{\link{plotPartialDependence}},
  \code{\link{plotROCCurves}}, \code{\link{plotResiduals}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}

Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{batchmark}}, \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearnerShortNames}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}}, \code{\link{getBMRModels}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskDescs}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCritDifferences}},
  \code{\link{reduceBatchmarkResults}}
}
