% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeFilterWrapper}
\alias{makeFilterWrapper}
\title{Fuse learner with a feature filter method.}
\usage{
makeFilterWrapper(learner, fw.method = "random.forest.importance",
  fw.select = "perc", fw.val)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{fw.method}{[\code{character(1)}]\cr
See \code{\link{getFilterValues}}.
Default is \dQuote{random.forest.importance}.}

\item{fw.select}{[\code{character(1)}]\cr
See \code{\link{filterFeatures}}.
Default is \dQuote{perc}.}

\item{fw.val}{[\code{numeric(1)}]\cr
See \code{\link{filterFeatures}}.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Fuses a base learner with a filter method. Creates a learner object, which can be
used like any other learner object.
Internally uses \code{\link{filterFeatures}} before every model fit.

After training, the selected features can be retrieved with
\code{\link{getFilteredFeatures}}.

Note that observation weights do not influence the filtering and are simply passed
down to the next learner.
}
\examples{
task = makeClassifTask(data = iris, target = "Species")
lrn = makeLearner("classif.lda")
inner = makeResampleDesc("Holdout")
outer = makeResampleDesc("CV", iters = 2)
lrn = makeFilterWrapper(lrn, fw.val = 0.5)
mod = train(lrn, task)
print(getFilteredFeatures(mod))
# now nested resampling, where we extract the features that the filter method selected
r = resample(lrn, task, outer, extract = function(model) {
  getFilteredFeatures(model)
})
print(r$extract)
}
\seealso{
Other filter: \code{\link{FilterResult}},
  \code{\link{getFilterResult}};
  \code{\link{FilterValues}}; \code{\link{filterFeatures}};
  \code{\link{getFilterValues}};
  \code{\link{getFilteredFeatures}};
  \code{\link{listFilterMethods}}
}

