% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_converter.R
\name{image_converter}
\alias{image_converter}
\title{Image Converter}
\usage{
image_converter(
  input,
  channels = NA,
  dataset = NA,
  height = NA,
  quality = NA,
  save = FALSE,
  verbose = FALSE,
  width = NA
)
}
\arguments{
\item{input}{Image filenames which have to be loaded/saved (character
vector).}

\item{channels}{Number of channels in the image.  Default value "0"
(integer).}

\item{dataset}{Input matrix to save as images (numeric matrix).}

\item{height}{Height of the images.  Default value "0" (integer).}

\item{quality}{Compression of the image if saved as jpg (0-100). 
Default value "90" (integer).}

\item{save}{Save a dataset as images.  Default value "FALSE" (logical).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value "FALSE"
(logical).}

\item{width}{Width of the image.  Default value "0" (integer).}
}
\value{
A list with several components:
\item{output}{Matrix to save images data to, Onlyneeded if you are
  specifying 'save' option (numeric matrix).}
}
\description{
A utility to load an image or set of images into a single dataset that can
then be used by other mlpack methods and utilities. This can also unpack an
image dataset into individual files, for instance after mlpack methods have
been used.
}
\details{
This utility takes an image or an array of images and loads them to a matrix.
You can optionally specify the height "height" width "width" and channel
"channels" of the images that needs to be loaded; otherwise, these parameters
will be automatically detected from the image.
There are other options too, that can be specified such as "quality".

You can also provide a dataset and save them as images using "dataset" and
"save" as an parameter.
}
\examples{
#  An example to load an image : 

\dontrun{
output <- image_converter(input=X, height=256, width=256, channels=3)
Y <- output$output
}

#  An example to save an image is :

\dontrun{
image_converter(input=X, height=256, width=256, channels=3, dataset=Y,
  save=TRUE)
}
}
\author{
mlpack developers
}
