## ---- include = FALSE---------------------------------------------------------
# nolint start
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup--------------------------------------------------------------------
#  library(mlexperiments)
#  library(mllrnrs)

## -----------------------------------------------------------------------------
#  library(mlbench)
#  data("PimaIndiansDiabetes2")
#  dataset <- PimaIndiansDiabetes2 |>
#    data.table::as.data.table() |>
#    na.omit()
#  
#  feature_cols <- colnames(dataset)[1:8]
#  target_col <- "diabetes"

## -----------------------------------------------------------------------------
#  seed <- 123
#  if (isTRUE(as.logical(Sys.getenv("_R_CHECK_LIMIT_CORES_")))) {
#    # on cran
#    ncores <- 2L
#  } else {
#    ncores <- ifelse(
#      test = parallel::detectCores() > 4,
#      yes = 4L,
#      no = ifelse(
#        test = parallel::detectCores() < 2L,
#        yes = 1L,
#        no = parallel::detectCores()
#      )
#    )
#  }
#  options("mlexperiments.bayesian.max_init" = 10L)

## -----------------------------------------------------------------------------
#  data_split <- splitTools::partition(
#    y = dataset[, get(target_col)],
#    p = c(train = 0.7, test = 0.3),
#    type = "stratified",
#    seed = seed
#  )
#  
#  train_x <- model.matrix(
#    ~ -1 + .,
#    dataset[data_split$train, .SD, .SDcols = feature_cols]
#  )
#  train_y <- dataset[data_split$train, get(target_col)]
#  
#  
#  test_x <- model.matrix(
#    ~ -1 + .,
#    dataset[data_split$test, .SD, .SDcols = feature_cols]
#  )
#  test_y <- dataset[data_split$test, get(target_col)]

## -----------------------------------------------------------------------------
#  fold_list <- splitTools::create_folds(
#    y = train_y,
#    k = 3,
#    type = "stratified",
#    seed = seed
#  )

## -----------------------------------------------------------------------------
#  # required learner arguments, not optimized
#  learner_args <- list(probability = TRUE)
#  
#  # set arguments for predict function and performance metric,
#  # required for mlexperiments::MLCrossValidation and
#  # mlexperiments::MLNestedCV
#  predict_args <- list(prob = TRUE, positive = "pos")
#  performance_metric <- metric("auc")
#  performance_metric_args <- list(positive = "pos")
#  return_models <- FALSE
#  
#  # required for grid search and initialization of bayesian optimization
#  parameter_grid <- expand.grid(
#    num.trees = seq(500, 1000, 500),
#    mtry = seq(2, 6, 2),
#    min.node.size = seq(1, 9, 4),
#    max.depth = seq(1, 9, 4),
#    sample.fraction = seq(0.5, 0.8, 0.3)
#  )
#  # reduce to a maximum of 10 rows
#  if (nrow(parameter_grid) > 10) {
#    set.seed(123)
#    sample_rows <- sample(seq_len(nrow(parameter_grid)), 10, FALSE)
#    parameter_grid <- kdry::mlh_subset(parameter_grid, sample_rows)
#  }
#  
#  # required for bayesian optimization
#  parameter_bounds <- list(
#    num.trees = c(100L, 1000L),
#    mtry = c(2L, 9L),
#    min.node.size = c(1L, 20L),
#    max.depth = c(1L, 40L),
#    sample.fraction = c(0.3, 1.)
#  )
#  optim_args <- list(
#    iters.n = ncores,
#    kappa = 3.5,
#    acq = "ucb"
#  )

## -----------------------------------------------------------------------------
#  tuner <- mlexperiments::MLTuneParameters$new(
#    learner = mllrnrs::LearnerRanger$new(),
#    strategy = "grid",
#    ncores = ncores,
#    seed = seed
#  )
#  
#  tuner$parameter_grid <- parameter_grid
#  tuner$learner_args <- learner_args
#  tuner$split_type <- "stratified"
#  
#  tuner$set_data(
#    x = train_x,
#    y = train_y
#  )
#  
#  tuner_results_grid <- tuner$execute(k = 3)
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================>------------------------------------------------] 5/10 ( 50%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=========================================================>--------------------------------------] 6/10 ( 60%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================================================================>-----------------------------] 7/10 ( 70%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================================================================>-------------------] 8/10 ( 80%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================================================================>----------] 9/10 ( 90%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================================================================] 10/10 (100%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  
#  head(tuner_results_grid)
#  #>    setting_id metric_optim_mean num.trees mtry min.node.size max.depth sample.fraction probability
#  #> 1:          1         0.1750403       500    2             9         5             0.5        TRUE
#  #> 2:          2         0.1712560       500    2             5         5             0.8        TRUE
#  #> 3:          3         0.1712560       500    4             9         9             0.5        TRUE
#  #> 4:          4         0.2335749      1000    2             9         1             0.5        TRUE
#  #> 5:          5         0.2479871       500    2             9         1             0.8        TRUE
#  #> 6:          6         0.1859098      1000    6             1         9             0.5        TRUE

## -----------------------------------------------------------------------------
#  tuner <- mlexperiments::MLTuneParameters$new(
#    learner = mllrnrs::LearnerRanger$new(),
#    strategy = "bayesian",
#    ncores = ncores,
#    seed = seed
#  )
#  
#  tuner$parameter_grid <- parameter_grid
#  tuner$parameter_bounds <- parameter_bounds
#  
#  tuner$learner_args <- learner_args
#  tuner$optim_args <- optim_args
#  
#  tuner$split_type <- "stratified"
#  
#  tuner$set_data(
#    x = train_x,
#    y = train_y
#  )
#  
#  tuner_results_bayesian <- tuner$execute(k = 3)
#  #>
#  #> Registering parallel backend using 4 cores.
#  
#  head(tuner_results_bayesian)
#  #>    Epoch setting_id num.trees mtry min.node.size max.depth sample.fraction gpUtility acqOptimum inBounds Elapsed      Score
#  #> 1:     0          1       500    2             9         5             0.5        NA      FALSE     TRUE   1.005 -0.1749597
#  #> 2:     0          2       500    2             5         5             0.8        NA      FALSE     TRUE   1.008 -0.1748792
#  #> 3:     0          3       500    4             9         9             0.5        NA      FALSE     TRUE   0.995 -0.1786634
#  #> 4:     0          4      1000    2             9         1             0.5        NA      FALSE     TRUE   0.987 -0.2407407
#  #> 5:     0          5       500    2             9         1             0.8        NA      FALSE     TRUE   0.090 -0.2335749
#  #> 6:     0          6      1000    6             1         9             0.5        NA      FALSE     TRUE   0.332 -0.1785829
#  #>    metric_optim_mean errorMessage probability
#  #> 1:         0.1749597         <NA>        TRUE
#  #> 2:         0.1748792         <NA>        TRUE
#  #> 3:         0.1786634         <NA>        TRUE
#  #> 4:         0.2407407         <NA>        TRUE
#  #> 5:         0.2335749         <NA>        TRUE
#  #> 6:         0.1785829         <NA>        TRUE

## -----------------------------------------------------------------------------
#  validator <- mlexperiments::MLCrossValidation$new(
#    learner = mllrnrs::LearnerRanger$new(),
#    fold_list = fold_list,
#    ncores = ncores,
#    seed = seed
#  )
#  
#  validator$learner_args <- tuner$results$best.setting[-1]
#  
#  validator$predict_args <- predict_args
#  validator$performance_metric <- performance_metric
#  validator$performance_metric_args <- performance_metric_args
#  validator$return_models <- return_models
#  
#  validator$set_data(
#    x = train_x,
#    y = train_y
#  )
#  
#  validator_results <- validator$execute()
#  #>
#  #> CV fold: Fold1
#  #>
#  #> CV fold: Fold2
#  #>
#  #> CV fold: Fold3
#  
#  head(validator_results)
#  #>     fold performance num.trees mtry min.node.size max.depth sample.fraction probability
#  #> 1: Fold1   0.8730830      1000    2             9         9             0.5        TRUE
#  #> 2: Fold2   0.8836594      1000    2             9         9             0.5        TRUE
#  #> 3: Fold3   0.8937253      1000    2             9         9             0.5        TRUE

## -----------------------------------------------------------------------------
#  validator <- mlexperiments::MLNestedCV$new(
#    learner = mllrnrs::LearnerRanger$new(),
#    strategy = "grid",
#    fold_list = fold_list,
#    k_tuning = 3L,
#    ncores = ncores,
#    seed = seed
#  )
#  
#  validator$parameter_grid <- parameter_grid
#  validator$learner_args <- learner_args
#  validator$split_type <- "stratified"
#  
#  validator$predict_args <- predict_args
#  validator$performance_metric <- performance_metric
#  validator$performance_metric_args <- performance_metric_args
#  validator$return_models <- return_models
#  
#  validator$set_data(
#    x = train_x,
#    y = train_y
#  )
#  
#  validator_results <- validator$execute()
#  #>
#  #> CV fold: Fold1
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================>------------------------------------------------] 5/10 ( 50%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=========================================================>--------------------------------------] 6/10 ( 60%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================================================================>-----------------------------] 7/10 ( 70%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================================================================>-------------------] 8/10 ( 80%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================================================================>----------] 9/10 ( 90%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================================================================] 10/10 (100%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> CV fold: Fold2
#  #> CV progress [====================================================================>-----------------------------------] 2/3 ( 67%)
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================>------------------------------------------------] 5/10 ( 50%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=========================================================>--------------------------------------] 6/10 ( 60%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================================================================>-----------------------------] 7/10 ( 70%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================================================================>-------------------] 8/10 ( 80%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================================================================>----------] 9/10 ( 90%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================================================================] 10/10 (100%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> CV fold: Fold3
#  #> CV progress [========================================================================================================] 3/3 (100%)
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================>----------------------------------------------------------] 4/10 ( 40%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================>------------------------------------------------] 5/10 ( 50%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=========================================================>--------------------------------------] 6/10 ( 60%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================================================================>-----------------------------] 7/10 ( 70%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================================================================>-------------------] 8/10 ( 80%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================================================================>----------] 9/10 ( 90%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================================================================] 10/10 (100%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  
#  head(validator_results)
#  #>     fold performance num.trees mtry min.node.size max.depth sample.fraction probability
#  #> 1: Fold1   0.8714966      1000    6             1         9             0.5        TRUE
#  #> 2: Fold2   0.8725542       500    4             9         9             0.8        TRUE
#  #> 3: Fold3   0.8886376       500    2             9         5             0.5        TRUE

## -----------------------------------------------------------------------------
#  validator <- mlexperiments::MLNestedCV$new(
#    learner = mllrnrs::LearnerRanger$new(),
#    strategy = "bayesian",
#    fold_list = fold_list,
#    k_tuning = 3L,
#    ncores = ncores,
#    seed = 312
#  )
#  
#  validator$parameter_grid <- parameter_grid
#  validator$learner_args <- learner_args
#  validator$split_type <- "stratified"
#  
#  
#  validator$parameter_bounds <- parameter_bounds
#  validator$optim_args <- optim_args
#  
#  validator$predict_args <- predict_args
#  validator$performance_metric <- performance_metric
#  validator$performance_metric_args <- performance_metric_args
#  validator$return_models <- TRUE
#  
#  validator$set_data(
#    x = train_x,
#    y = train_y
#  )
#  
#  validator_results <- validator$execute()
#  #>
#  #> CV fold: Fold1
#  #>
#  #> Registering parallel backend using 4 cores.
#  #>
#  #> CV fold: Fold2
#  #> CV progress [====================================================================>-----------------------------------] 2/3 ( 67%)
#  #>
#  #> Registering parallel backend using 4 cores.
#  #>
#  #> CV fold: Fold3
#  #> CV progress [========================================================================================================] 3/3 (100%)
#  #>
#  #> Registering parallel backend using 4 cores.
#  
#  head(validator_results)
#  #>     fold performance num.trees mtry min.node.size max.depth sample.fraction probability
#  #> 1: Fold1   0.8754627      1000    6             1         9             0.5        TRUE
#  #> 2: Fold2   0.8767848       500    4             9         9             0.8        TRUE
#  #> 3: Fold3   0.8971170       500    2             5         9             0.5        TRUE

## -----------------------------------------------------------------------------
#  preds_ranger <- mlexperiments::predictions(
#    object = validator,
#    newdata = test_x
#  )

## -----------------------------------------------------------------------------
#  perf_ranger <- mlexperiments::performance(
#    object = validator,
#    prediction_results = preds_ranger,
#    y_ground_truth = test_y,
#    type = "binary"
#  )
#  perf_ranger
#  #>    model performance       auc     prauc sensitivity specificity       ppv       npv tn tp fn fp       tnr       tpr       fnr
#  #> 1: Fold1   0.7874067 0.7874067 0.6119292   0.4615385   0.8481013 0.6000000 0.7613636 67 18 21 12 0.8481013 0.4615385 0.5384615
#  #> 2: Fold2   0.7802661 0.7802661 0.5977887   0.4615385   0.8860759 0.6666667 0.7692308 70 18 21  9 0.8860759 0.4615385 0.5384615
#  #> 3: Fold3   0.7831873 0.7831873 0.6174674   0.4615385   0.8354430 0.5806452 0.7586207 66 18 21 13 0.8354430 0.4615385 0.5384615
#  #>          fpr    bbrier       acc        ce     fbeta
#  #> 1: 0.1518987 0.1735079 0.7203390 0.2796610 0.5217391
#  #> 2: 0.1139241 0.1838647 0.7457627 0.2542373 0.5454545
#  #> 3: 0.1645570 0.1754549 0.7118644 0.2881356 0.5142857

## ----include=FALSE------------------------------------------------------------
#  # nolint end

