% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-client.R
\name{mlflow_client_restore_experiment}
\alias{mlflow_client_restore_experiment}
\title{Restore Experiment}
\usage{
mlflow_client_restore_experiment(client, experiment_id)
}
\arguments{
\item{client}{An `mlflow_client` object.}

\item{experiment_id}{ID of the associated experiment. This field is required.}
}
\description{
Restore an experiment marked for deletion. This also restores associated metadata,
  runs, metrics, and params. If experiment uses FileStore, underlying artifacts
  associated with experiment are also restored.
}
\details{
Throws RESOURCE_DOES_NOT_EXIST if experiment was never created or was permanently deleted.

The Tracking Client family of functions require an MLflow client to be
  specified explicitly. These functions allow for greater control of where the
  operations take place in terms of services and runs, but are more verbose
  compared to the Fluent API.
}
\keyword{internal}
