% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMetabolicRate.R
\name{setMetabolicRate}
\alias{setMetabolicRate}
\alias{getMetabolicRate}
\alias{metab}
\alias{metab<-}
\title{Set metabolic rate}
\usage{
setMetabolicRate(params, metab = NULL, p = NULL, reset = FALSE, ...)

getMetabolicRate(params)

metab(params)

metab(params) <- value
}
\arguments{
\item{params}{MizerParams}

\item{metab}{Optional. An array (species x size) holding the metabolic rate
for each species at size. If not supplied, a default is set as described in
the section "Setting metabolic rate".}

\item{p}{The allometric metabolic exponent. This is only used if \code{metab}
is not given explicitly and if the exponent is not specified in a \code{p}
column in the \code{species_params}.}

\item{reset}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
If set to TRUE, then the metabolic rate will be reset to the
value calculated from the species parameters, even if it was previously
overwritten with a custom value. If set to FALSE (default) then a
recalculation from the species parameters will take place only if no
custom value has been set.}

\item{...}{Unused}

\item{value}{metab}
}
\value{
\code{setMetabolicRate()}: A MizerParams object with updated metabolic rate.

\code{getMetabolicRate()} or equivalently \code{metab()}: An array
(species x size) with the metabolic rate.
}
\description{
Sets the rate at which energy is used for metabolism and activity
}
\section{Setting metabolic rate}{

The metabolic rate is subtracted from the energy income rate to calculate
the rate at which energy is available for growth and reproduction, see
\code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}. It is measured in grams/year.

If the \code{metab} argument is not supplied, then for each species the
metabolic rate \eqn{k(w)} for an individual of size \eqn{w} is set to
\deqn{k(w) = k_s w^p + k w,}
where \eqn{k_s w^p} represents the rate of standard metabolism and \eqn{k w}
is the rate at which energy is expended on activity and movement. The values
of \eqn{k_s}, \eqn{p} and \eqn{k} are taken from the \code{ks}, \code{p} and
\code{k} columns in the species parameter dataframe. If any of these
parameters are not supplied, the defaults are \eqn{k = 0}, \eqn{p = n} and
\deqn{k_s = f_c h \alpha w_{mat}^{n-p},}{k_s = f_c * h * alpha * w_mat^(n - p),}
where \eqn{f_c} is the critical feeding level taken from the \code{fc} column
in the species parameter data frame. If the critical feeding level is not
specified, a default of \eqn{f_c = 0.2} is used.
}

\seealso{
Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{setExtEncounter}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
