% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{getBiomass}
\alias{getBiomass}
\title{Calculate the total biomass of each species within a size range at each time
step.}
\usage{
getBiomass(object, ...)
}
\arguments{
\item{object}{An object of class \code{MizerParams} or \code{MizerSim}.}

\item{...}{
  Arguments passed on to \code{\link[=get_size_range_array]{get_size_range_array}}
  \describe{
    \item{\code{min_w}}{Smallest weight in size range. Defaults to smallest weight in
the model.}
    \item{\code{max_w}}{Largest weight in size range. Defaults to largest weight in the
model.}
    \item{\code{min_l}}{Smallest length in size range. If supplied, this takes
precedence over \code{min_w}.}
    \item{\code{max_l}}{Largest length in size range. If supplied, this takes precedence
over \code{max_w}.}
  }}
}
\value{
If called with a MizerParams object, a vector with the biomass in
grams for each species in the model. If called with a MizerSim object, an
array (time x species) containing the biomass in grams at each time step
for all species.
}
\description{
Calculates the total biomass through time within user defined size limits.
The default option is to use the whole size range. You can specify minimum
and maximum weight or length range for the species. Lengths take precedence
over weights (i.e. if both min_l and min_w are supplied, only min_l will be
used).
}
\examples{
biomass <- getBiomass(NS_sim)
biomass["1972", "Herring"]
biomass <- getBiomass(NS_sim, min_w = 10, max_w = 1000)
biomass["1972", "Herring"]
}
\seealso{
Other summary functions: 
\code{\link{getDiet}()},
\code{\link{getGrowthCurves}()},
\code{\link{getN}()},
\code{\link{getSSB}()},
\code{\link{getYield}()},
\code{\link{getYieldGear}()}
}
\concept{summary functions}
\concept{summary_function}
