% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{getYieldGear}
\alias{getYieldGear}
\title{Calculate the yearly yield per gear and species}
\usage{
getYieldGear(sim)
}
\arguments{
\item{sim}{An object of class \code{MizerSim}.}
}
\value{
An array (time x gear x species) containing the yearly yield in
grams.
}
\description{
Calculates the yearly yield (biomass fished per year) per gear and species at
each simulation time step.
}
\examples{
yield <- getYieldGear(NS_sim)
yield["1972", "Herring", "Herring"]
# (In this example MizerSim object each species was set up with its own gear)
}
\seealso{
\code{\link[=getYield]{getYield()}}

Other summary functions: 
\code{\link{getBiomass}()},
\code{\link{getDiet}()},
\code{\link{getGrowthCurves}()},
\code{\link{getN}()},
\code{\link{getSSB}()},
\code{\link{getYield}()}
}
\concept{summary functions}
\concept{summary_function}
