% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getM2}
\alias{getM2}
\title{Alias for \code{getPredMort()}}
\usage{
getM2(object, n, n_pp, n_other, time_range, drop = TRUE, ...)
}
\arguments{
\item{object}{A \code{MizerParams} object or a \code{MizerSim} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{time_range}{A vector of times. Only the range of times is relevant,
i.e., all times between the smallest and largest will be selected.
The time_range can be character or numeric.}

\item{drop}{If \code{TRUE} then any dimension of length 1 will be removed
from the returned array.}

\item{...}{Unused}
}
\value{
If a \code{MizerParams} object is passed in, the function returns a two
dimensional array (prey species x prey size) based on the abundances also
passed in. If a \code{MizerSim} object is passed in, the function returns a
three dimensional array (time step x prey species x prey size) with the
predation mortality calculated at every time step in the simulation.
Dimensions may be dropped if they have length 1 unless \code{drop = FALSE}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
An alias provided for backward compatibility with mizer version <= 1.0
}
\section{Your own predation mortality function}{

By default \code{\link[=getPredMort]{getPredMort()}} calls \code{\link[=mizerPredMort]{mizerPredMort()}}. However you can
replace this with your own alternative predation mortality function. If
your function is called \code{"myPredMort"} then you register it in a MizerParams
object \code{params} with\preformatted{params <- setRateFunction(params, "PredMort", "myPredMort")
}

Your function will then be called instead of \code{\link[=mizerPredMort]{mizerPredMort()}}, with the
same arguments.
}

\examples{
\dontrun{
params <- NS_params
# With constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get predation mortality at one time step
getPredMort(params, n = N(sim)[15, , ], n_pp = NResource(sim)[15, ])
# Get predation mortality at all saved time steps
getPredMort(sim)
# Get predation mortality over the years 15 - 20
getPredMort(sim, time_range = c(15, 20))
}
}
\seealso{
Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getRates}()},
\code{\link{getResourceMort}()}
}
\concept{deprecated}
