% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs-binom-pois.R
\name{Metropolis-within-Gibbs Sampler}
\alias{Metropolis-within-Gibbs Sampler}
\alias{gibbs.mixlink.reg}
\title{Metropolis-within-Gibbs Sampler}
\usage{
gibbs.mixlink.reg(y, X, R, burn = 0, thin = 1, invlink = NULL,
  report.period = 100, save.psi = FALSE, Beta.init = NULL, Pi.init,
  kappa.init = NULL, psi.init = NULL, proposal.VBeta = NULL,
  proposal.VPi = NULL, proposal.Vkappa = NULL, proposal.Vpsi = NULL,
  hyper = NULL, trials = NULL, offset = rep(0, length(y)),
  family = NULL, fixed.kappa = FALSE)
}
\arguments{
\item{y}{Observations.}

\item{X}{Design matrix for regression.}

\item{R}{Number of MCMC draws to take.}

\item{burn}{Number of initial MCMC draws to discard.}

\item{thin}{After burn-in period, save one of every \code{thin} draws.}

\item{invlink}{The inverse link function for the mean. Default is \code{NULL},
which indicates to use \code{plogis} for Binomial and \code{exp} for Poisson.}

\item{report.period}{Report progress every \code{report.period} draws.}

\item{save.psi}{Save draws for \eqn{\bm{\psi}_1, \ldots, \bm{\psi}_n}. Default is
\code{FALSE}.}

\item{Beta.init}{Starting value for \eqn{\bm{\beta}}.}

\item{Pi.init}{Starting value for \eqn{\bm{\pi}}. The length of \code{Pi.init}
determines \eqn{J} used in MCMC.}

\item{kappa.init}{Starting value for \eqn{\kappa}.}

\item{psi.init}{Starting value for \eqn{\bm{\psi}_1, \ldots, \bm{\psi}_n}}

\item{proposal.VBeta}{Covariance matrix for \eqn{d} dimensional multivariate normal
proposal. If left at the default (NULL), we use \code{diag(0.01^2, d)}.}

\item{proposal.VPi}{Covariance matrix for \eqn{J-1} dimensional multivariate normal
proposal. If left at the default (NULL), we use \code{diag(0.01^2, J-1)}.}

\item{proposal.Vkappa}{Covariance matrix for univariate normal proposal. If left at
the default (NULL), we use \code{0.01^2}.}

\item{proposal.Vpsi}{Covariance matrix for univariate normal proposal. If left at
the default (NULL), we use \code{diag(0.01^2, J)}.}

\item{hyper}{A list with hyperparameters corresponding to the prior from the
Details section. \code{var.Beta} is \eqn{V_{\beta}} with default 1000.
\code{alpha.Pi} is \eqn{\bm{\alpha}_\pi} with default \code{rep(1,J)}.
\code{a.kappa} and \code{b.kappa} correspond to \eqn{(a_\kappa, b_\kappa)}
which have default values \code{a.kappa = 1} and \code{b.kappa = 1/10}.}

\item{trials}{Number of success/failure trials.}

\item{offset}{Offset term to add to regression function, as commonly used in count
models.}

\item{family}{Can be either \code{binomial} or \code{poisson}.}

\item{fixed.kappa}{Keep \eqn{\kappa} fixed at \code{kappa.init} (Default FALSE).}
}
\value{
A list with the MCMC results:
\item{Beta.hist}{\eqn{R \times d} matrix of saved \eqn{\bm{\beta}} draws.}
\item{Pi.hist}{\eqn{R \times J} matrix of saved \eqn{\bm{\pi}} draws.}
\item{kappa.hist}{\eqn{R \times 1} vector of \eqn{\kappa} draws.}
\item{psi.hist}{A list of \eqn{J} \eqn{R \times n} matrices. The \eqn{j}th matrix 
  contains the MCMC draws for \eqn{\bm{\psi}_{ij}}.}
\item{accept.Beta}{Percentages of MCMC proposals for \eqn{\bm{\beta}} were accepted.}
\item{accept.Pi}{Percentages of MCMC proposals for \eqn{\bm{\pi}} were accepted.}
\item{accept.kappa}{Percentages of MCMC proposals for \eqn{\kappa} were accepted.}
\item{accept.psi}{Percentages of MCMC proposals for \eqn{\bm{\psi}} were accepted.}
\item{elapsed.sec}{Elapsed time for sampling, in seconds.}
\item{R}{Number of total draws.}
\item{R.keep}{Number of draws kept, after thinning and burn-in.}
\item{X.names}{Names of columns of design matrix.}
\item{family}{Name of family / outcome.}
Can be accessed with the functions \code{print}, \code{summary}, and \code{DIC}.
}
\description{
Metropolis-within-Gibbs sampler for Binomial and Poisson Mixture Link models.
}
\details{
Priors for Bayesian Mixture Link model are
\itemize{
\item{\eqn{ \bm{\beta} \sim \textrm{N}(\bm{0}, V_{\beta} \bm{I}) }},
\item{\eqn{ \bm{\pi} \sim \textrm{Dirichlet}_J(\bm{\alpha}_\pi) }},
\item{\eqn{ \kappa \sim \textrm{Gamma}(a_\kappa, b_\kappa) }}, parameterized with 
      \eqn{\textrm{E}(\kappa) = a_\kappa / b_\kappa}.
}
}
\examples{
# ----- Generate data -----
n <- 200
m <- rep(20, n)
x <- rnorm(n, 0, 1)
X <- model.matrix(~ x)
Beta.true <- c(-1, 1)
mean.true <- plogis(X \%*\% Beta.true)
kappa.true <- 1
Pi.true <- c(1,3)/4
d <- ncol(X)
J <- length(Pi.true)
y <- r.mixlink.binom(n, mean.true, Pi.true, kappa.true, m)

# ----- Run Metropolis-within-Gibbs sampler -----
hyper <- list(VBeta = diag(1000, d), alpha.Pi = rep(1, J),
	kappa.a = 1, kappa.b = 1/2)
gibbs.out <- gibbs.mixlink.reg(y, X, R = 10, burn = 5, thin = 1,
	invlink = plogis, report.period = 100, Pi.init = c(1,9)/10,
	proposal.VBeta = solve(t(X) \%*\% X), proposal.VPi = diag(0.25^2, J-1),
	proposal.Vkappa = 0.5^2, proposal.Vpsi = diag(0.5^2, J),
	hyper = hyper, family = "binomial", trials = m)

print(gibbs.out)
DIC.gibbs.mixlink.reg(gibbs.out, y, X, trials = m, invlink = plogis,
	family = "binomial")

}
\references{
Andrew M. Raim, Nagaraj K. Neerchal, and Jorge G. Morel.
            An Extension of Generalized Linear Models to Finite
            Mixture Outcomes. arXiv preprint: 1612.03302
}

