% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrop-binom.R, R/metrop-pois.R, R/mixlink-package.R
\name{DIC for Random-Walk Metropolis Hastings Sampler}
\alias{DIC for Random-Walk Metropolis Hastings Sampler}
\alias{DIC.rwmetrop.mixlink.binomial}
\alias{DIC.rwmetrop.mixlink.poisson}
\title{DIC for Random-Walk Metropolis Hastings Sampler}
\usage{
DIC.rwmetrop.mixlink.binomial(metrop.out, y, m, X, invlink = plogis)

DIC.rwmetrop.mixlink.poisson(metrop.out, y, X, offset = rep(0, length(y)),
  invlink = exp)
}
\arguments{
\item{metrop.out}{Results from Random-Walk Metropolis Hastings sampler.}

\item{y}{Observations.}

\item{m}{Number of success/failure trials}

\item{X}{Design matrix for regression.}

\item{invlink}{The inverse link function for the mean. Default is \code{NULL},
which indicates to use \code{plogis} for Binomial and \code{exp} for Poisson.}

\item{offset}{Offset term to add to regression function, as commonly used in count
models.}
}
\value{
DIC
}
\description{
Deviance Information Criteria (DIC) computed on results from
Metropolis-within-Gibbs sampler.
}

