% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KendallCCA.R
\name{find_w12bic}
\alias{find_w12bic}
\title{Internal mixedCCA function finding w1 and w2 given R1, R2 and R12}
\usage{
find_w12bic(
  n,
  R1,
  R2,
  R12,
  lamseq1,
  lamseq2,
  w1init,
  w2init,
  BICtype,
  maxiter = 100,
  tol = 0.01,
  trace = FALSE,
  lassoverbose = FALSE
)
}
\arguments{
\item{n}{Sample size}

\item{R1}{Correlation matrix of dataset \code{X1} (p1 by p1)}

\item{R2}{Correlation matrix of dataset \code{X2} (p2 by p2)}

\item{R12}{Correlation matrix between the dataset \code{X1} and the dataset \code{X2} (p1 by p2)}

\item{lamseq1}{A sequence of lambda values for the datasets \code{X1}. It can be a scalar (a vector of one value). should be the same length with lamseq2.}

\item{lamseq2}{A sequence of lambda values for the datasets \code{X2}. It can be a scalar (a vector of one value). should be the same length with lamseq1.}

\item{w1init}{An initial vector of length p1 for canonical direction \eqn{w1}.}

\item{w2init}{An initial vector of length p1 for canonical direction \eqn{w2}.}

\item{BICtype}{Either 1 or 2: For more details for two options, see the reference.}

\item{maxiter}{The maximum number of iterations allowed.}

\item{tol}{The desired accuracy (convergence tolerance).}

\item{trace}{If \code{trace = TRUE}, progress per each iteration will be printed. The default value is \code{FALSE}.}

\item{lassoverbose}{If \code{lassoverbose = TRUE}, all warnings from lassobic optimization regarding convergence will be printed. The default value is \code{lassoverbose = FALSE}.}
}
\value{
\code{find_w12bic} returns a data.frame containing
\itemize{
      \item{w1: }{estimated canonical direction \eqn{w1}.}
      \item{w2: }{estimated canonical direction \eqn{w2}.}
      \item{w1trace: }{a matrix, of which column is the estimated canonical direction \eqn{w1} at each iteration. The number of columns is the number of iteration until the convergence.}
      \item{w2trace: }{a matrix, of which column is the estimated canonical direction \eqn{w2} at each iteration. The number of columns is the number of iteration until the convergence.}
      \item{lam1.iter: }{For each iteration, what lambda value is selected for \eqn{w1} is stored.}
      \item{lam2.iter: }{For each iteration, what lambda value is selected for \eqn{w2} is stored.}
      \item{obj: }{objective function value without penalty: \eqn{w1^T * R12 * w2}. If lamseq1 and lamseq2 are scalar, then original objective function including penalty part will be used.}
}
}
\description{
Internal mixedCCA function finding w1 and w2 given R1, R2 and R12
}
\references{
Yoon G., Carroll R.J. and Gaynanova I. (2020) "Sparse semiparametric canonical correlation analysis for data of mixed types" <doi:10.1093/biomet/asaa007>.
}
