% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.sort.R
\name{df.sort}
\alias{df.sort}
\title{Data Frame Sorting}
\usage{
df.sort(data, ..., decreasing = FALSE, check = TRUE)
}
\arguments{
\item{data}{a data frame.}

\item{...}{a sorting variable or a sequence of sorting variables which are specified without
quotes \code{''} or double quotes \code{""}.}

\item{decreasing}{logical: if \code{TRUE}, the sort is decreasing.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\value{
Returns data frame \code{data} sorted according to the variables specified in \code{...},
a matrix will be coerced to a data frame.
}
\description{
This function arranges a data frame in increasing or decreasing order according to one or more variables.
}
\examples{
# Example 1: Sort data frame 'mtcars' by 'mpg' in increasing order
df.sort(mtcars, mpg)

# Example 2: Sort data frame 'mtcars' by 'mpg' in decreasing order
df.sort(mtcars, mpg, decreasing = TRUE)

# Example 3: Sort data frame 'mtcars' by 'mpg' and 'cyl' in increasing order
df.sort(mtcars, mpg, cyl)

# Example 4: Sort data frame 'mtcars' by 'mpg' and 'cyl' in decreasing order
df.sort(mtcars, mpg, cyl, decreasing = TRUE)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) \emph{The New S Language}. Wadsworth & Brooks/Cole.

Knuth, D. E. (1998) \emph{The Art of Computer Programming, Volume 3: Sorting and Searching} (2nd ed.). Addison-Wesley.
}
\seealso{
\code{\link{df.check}}, \code{\link{df.duplicated}}, \code{\link{df.unique}},
\code{\link{df.head}}, \code{\link{df.tail}}, \code{\link{df.long}},
\code{\link{df.wide}}, \code{\link{df.merge}}, \code{\link{df.move}},
\code{\link{df.rbind}}, \code{\link{df.rename}},
\code{\link{df.subset}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
