% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.rename.R
\name{df.rename}
\alias{df.rename}
\title{Rename Columns in a Matrix or Variables in a Data Frame}
\usage{
df.rename(x, from, to, check = TRUE)
}
\arguments{
\item{x}{a matrix or data frame.}

\item{from}{a character string or character vector indicating the column(s) or variable(s) to be renamed.}

\item{to}{a character string or character vector indicating the corresponding replacement values for
the column(s) or variable(s) specified in the argument \code{name}.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\value{
Returns a matrix or data frame with renamed columns or variables.
}
\description{
This function renames columns in a matrix or variables in a data frame by specifying a character string or
character vector indicating the columns or variables to be renamed and a character string or character
vector indicating the corresponding replacement values.
}
\examples{
# Example 1: Rename 'cyl' in 'mtcars' to 'cylinder'
df.rename(mtcars, from = "cyl", to = "cylinder")

# Example 2: Rename 'cyl' and 'wt' in 'mtcars' to 'cylinder' and 'weight'
df.rename(mtcars, from = c("cyl", "wt"), to = c("cylinder", "weight"))
}
\seealso{
\code{\link{df.duplicated}}, \code{\link{df.merge}},
\code{\link{df.move}}, \code{\link{df.rbind}},
\code{\link{df.sort}},
\code{\link{df.subset}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
