% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.alpha.coef.R
\name{print.alpha.coef}
\alias{print.alpha.coef}
\title{Print alpha.coef object}
\usage{
\method{print}{alpha.coef}(x, print = x$args$print,
      digits = x$args$digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{alpha.coef} object.}

\item{print}{a character vector indicating which results to show, i.e. \code{"all"}, for all results
\code{"alpha"} for the coefficienta alpha, and \code{"item"} for item statistics.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
coefficient alpha and item-total correlations.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{alpha.coef} object
}
\examples{
dat <- data.frame(item1 = c(5, 2, 3, 4, 1, 2, 4, 2),
                  item2 = c(5, 1, 3, 5, 2, 2, 5, 1),
                  item3 = c(4, 2, 4, 5, 1, 3, 5, 1),
                  item4 = c(5, 1, 2, 5, 2, 3, 4, 2))

# Compute unstandardized coefficient alpha and item statistics
dat.alpha <- alpha.coef(dat, output = FALSE)

# Print alpha.coef object to show unstandardized coefficient alpha and item statistics with 3 digits
print(dat.alpha, digits = 3)

# Print alpha.coef object to show unstandardized coefficient with 3 digits
print(dat.alpha, print = "alpha", digits = 3)

# Print alpha.coef object to show item statistics with 3 digits
print(dat.alpha, print = "item", digits = 3)
}
\references{
Cronbach, L.J. (1951). Coefficient alpha and the internal strucuture of tests. \emph{Psychometrika, 16}, 297-334.

Cronbach, L.J. (2004). My current thoughts on coefficient alpha and successor procedures. \emph{Educational
and Psychological Measurement, 64}, 391-418.

Feldt, L. S., Woodruff, D. J., & Salih, F. A. (1987). Statistical inference for coefficient alpha.
\emph{Applied Psychological Measurement, 11} 93-103.

Kelley, K., & Pornprasertmanit, S. (2016). Confidence intervals for population reliability coefficients:
Evaluation of methods, recommendations, and software for composite measures. \emph{Psychological Methods, 21}, 69-92.
}
\seealso{
\code{\link{alpha.coef}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
