% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strpart.R
\name{str_part}
\alias{str_part}
\alias{strpart}
\title{Split String and Return Part}
\usage{
str_part(x, split, n, ..., roll = F)

strpart(x, split, n, ..., roll = F)
}
\arguments{
\item{x}{Character vector.}

\item{split}{Regular expression splitting strings.}

\item{n}{Number of part to extract.}

\item{...}{Arguments passed to \code{strsplit}.}

\item{roll}{Logical, if to use the last when less than maximum parts.}
}
\value{
A character vector of the extracted parts.
}
\description{
Return the \code{n}th part of a splitted string.
}
\examples{
#

s <- c("abc","abcd","abc")

str_part(s, "", 4)
str_part(s, "", 4, roll=TRUE)

#
}
\seealso{
\link{strsplit}
}
\author{
Sven E. Templer
}
\keyword{extract}
\keyword{part}
\keyword{string}
