% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par.cor.R
\name{par.cor}
\alias{par.cor}
\title{Partial and semipartial correlation}
\usage{
par.cor(x = NULL, y = NULL, p.xy = NULL, p.x = NULL, p.y = NULL,
  sig = FALSE, rho = 0, alternative = c("two.sided", "less", "greater"),
  reduced = FALSE, conf.level = 0.95, digits = 3, output = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{p.xy}{a numeric vector or data.frame, varialbe(s) residualized from x and y.}

\item{p.x}{a numeric vector or data.frame, varialbe(s) residualized only from x.}

\item{p.y}{a numeric vector or data.frame, varialbe(s) residualized only from y.}

\item{sig}{logical: if \code{TRUE}, statistical significance test is conducted.}

\item{rho}{a number indicating \eqn{\rho}0, the value under the null hypothesis.}

\item{alternative}{a character string describing the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{reduced}{logical: if \code{TRUE}, compuatation is based on the reduced formula.}

\item{conf.level}{confidence level of the interval.}

\item{digits}{integer indicating the number of decimal places to be displayed.}

\item{output}{logical: if \code{TRUE}, output is shown.}
}
\value{
Returns an object of class \code{par.cor} with following entries:

\tabular{ll}{
  \code{call}      \tab function call \cr
  \code{dat}       \tab list with data for x.resid (x residualized), y.resid (y residualized),
                         x, y, p.xy, p.y, and p.x \cr
  \code{spec}      \tab specification of function argument method \cr
  \code{res}       \tab list with results, i.e., t or z (test statistic), df (degree of freedom)
                        pval (significance value), r.p (partial or semipartial correlation coefficient),
                        n (sample size), lower (lower limit of CI), upper (upper limit of CI) \cr
}
}
\description{
This function computes the partial or semipartial correlation coefficient between two vaiables.
In addition, this function can test the partial or semipartial correlation coefficient for
H0: \eqn{\rho .p = \rho}0, so that any value for \eqn{\rho}0 can be specified.
}
\details{
Partial correlation is the correlation of \code{x} and \code{y} while statistically controlling
for third variables specified in the argument \code{p.xy}. These variables are residualized from
\code{x} and \code{y} using (multiple) regression models.
Semipartial correlation is the correlation of \code{x} and \code{y} while statistically controlling
for third variables only for \code{x} (specified in the argument \code{p.x}) or \code{y} (specified
in the argument \code{p.y}). These variables are residualized from \code{x} or \code{y} using a
(multiple) regression model.
}
\examples{
dat <- data.frame(x = c(4, 6, 8, 8, 9, 4),
                  y = c(3, 7, 9, 8, 9, 3),
                  z = c(1, 3, 4, 4, 5, 2))

#--------------------------------------
# Partial correlation

par.cor(dat$x, dat$y, p.xy = dat$z)

#--------------------------------------
# Semipartial correlation
# remove z from x

par.cor(dat$x, dat$y, p.x = dat$z)

#--------------------------------------
# Semipartial correlation
# remove z from y

par.cor(dat$x, dat$y, p.y = dat$y)

#--------------------------------------
# Partial correlation: Two-sided test
# H0: rho.p == 0, H1: rho.p != 0

par.cor(dat$x, dat$y, p.xy = dat$z, sig = TRUE)

#--------------------------------------
# Partial correlation: One-sided test
# H0: rho.p <= 0.2, H1: rho.p > 0.2

par.cor(dat$x, dat$y, p.xy = dat$z,
        sig = TRUE, rho = 0.4, alternative = "less")
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.
}
\seealso{
\code{\link{test.cor}}, \code{\link{conf.cor}}, \code{\link{comptest.cor}}, \code{\link{seqtest.cor}}
}

