% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{find_optimised_snps}
\alias{find_optimised_snps}
\title{\code{find_optimised_snps}}
\usage{
find_optimised_snps(
  seqc,
  metric = "simpson",
  goi = c(),
  accept_multiallelic = TRUE,
  number_of_result = 1,
  max_depth = 1,
  included_positions = c(),
  excluded_positions = c(),
  search_from = NULL,
  iterate_included = FALSE,
  completely_unique = FALSE,
  bp = SerialParam(),
  ...
)
}
\arguments{
\item{seqc}{list of sequences, either passed directly from
\code{process_allele} or \code{read_fasta} or equivalence}

\item{metric}{either `simpson` or `percent`}

\item{goi}{group of interest, if creteria is percent,
must be specified, ignored otherwise}

\item{accept_multiallelic}{whether include positions with > 1 state in goi}

\item{number_of_result}{number of results to return, 0 will be coerced to 1}

\item{max_depth}{maximum depth to go before terminating,
0 means it will only calculate the metric for included position}

\item{included_positions}{included positions}

\item{excluded_positions}{excluded positions}

\item{search_from}{search only from these positions, i.e.,
any positions not in here are excluded, default to NULL}

\item{iterate_included}{whether to calculate index
at each level of the included SNPs}

\item{completely_unique}{whether to identify completely unique SNPs set,
default to FALSE, only the 1st SNP must be different}

\item{bp}{BiocParallel backend.
Rule of thumbs: use MulticoreParam(workers = ncpus - 2)}

\item{...}{other parameters as needed}
}
\value{
Will return the resolution-optimised SNPs set, based on the metric.
}
\description{
\code{find_optimised_snps} is used to find optimised SNPs set.
}
