toMIM <- function(data) UseMethod("toMIM", data)

toMIM.gmData <- function(data){
  mim.cmd("clear; clear output")
  switch(.dataOrigin(data),
         "data.frame" = {.df.to.mim(data)},
         "suffStats"  = {.ss.to.mim(data)},
         "table"      = {.table.to.mim(data)}
         )
}

toMIM.data.frame <- function(data){
  cat("NOTE: Using new toMIM.data.frame\n")
  gmd <- as.gmData(data)
  toMIM(gmd)
}

.table.to.mim <- function(data){
  vs <-.nt.to.varspec(data)
  ss <- data$letter
  ss <- ss[length(ss):1]
  s  <- paste("Statread", paste(ss, collapse=''))
  res <- as.vector(observations(data))
  mim.cmd("# Suff stats")
  lapply(vs, mim.cmd)
  mim.cmd(s)
  lapply(.partition.mim.input(res),mim.cmd)
  mim.cmd("!", look.nice=FALSE)    

}


.ss.to.mim <- function(data){
  vs <-.nt.to.varspec(data)
  s  <- paste("Statread", paste(data$letter, collapse=''))
  res <- observations(data)
  str4     <- unlist( lapply( as.vector(t(res)), .float.to.string, n.digits=5, width=15))    
  mim.cmd("# Suff stats")
  lapply(vs, mim.cmd)
  mim.cmd(s)
  lapply(.partition.mim.input(str4),mim.cmd)
  mim.cmd("!", look.nice=FALSE)    
}


.df.to.mim <- function(data,file=NULL){
  ##cat(".df.to.mim\n")
  nt <- as.data.frame(data)
  vs <- .nt.to.varspec(nt)
  mdata <- observations(data)
  for (j in 1:ncol(mdata))
    mdata[,j] <- as.numeric(mdata[,j])
  str4     <- unlist( lapply( as.vector(t(mdata)), .float.to.string, n.digits=3, width=2))    
  var.letter <- .look.up.mim.names(names(mdata),nt,"to.mim")

  if (is.null(file)){
    specfile <- "mimR_df2mim"
    file     <- paste(getwd(),"\\",specfile,".txt",sep='')

  } else {
    if (length(grep(":", file))==0)
      file <- paste(getwd(),"\\",file,sep='')
  }
  tmp <- proc.time()
  ##cat("Writing MIM data file (in working dir)", specfile,"... ")
  write("%\n% DATA FILE AUTOMATICALLY GENERATED BY mimR", file, append=FALSE)
  write(paste("% TIME:", date(),  "%"), file, append=TRUE)
  write(paste("% FILE:", file,  "\n%"), file, append=TRUE)

  ##print(vs)
  lapply(vs, write, file,append=TRUE)
  write(paste("Read", paste(var.letter, collapse=' ')), file, append=TRUE)  

  write(str4, file, append=TRUE, ncolumns=20)
  write("!", file, append=TRUE)

  mim.cmd(paste("clear; clear output;"))
  str  <- paste("input", file, ";", sep=' ');
  mim.cmd(str, look.nice=FALSE);  
  #cat("Time taken:", (proc.time()-tmp)[3],"\n")
  return(file)
}




.nt.to.varspec <- function(nt){
  var.spec <-
    paste(
          paste("Fact", paste(nt$letter[nt$factor==TRUE],nt$levels[nt$factor==TRUE],collapse=' ')), ";",
          paste("Cont", paste(nt$letter[nt$factor==FALSE],collapse=' '))  )
  
  lab.spec <- paste("Labels", nt$letter,
                    gsub(' ','',paste('\"',nt$name,'\"'))
                    )

  vallab.list <- NULL


  factor.letter <- nt$letter[nt$factor==TRUE]
  factor.levels <- nt$levels[nt$factor==TRUE]
  if (length(factor.letter)>0){
    vl <- attr(nt, "vallabels")
    for (j in 1:length(factor.letter)){
      x1 <- paste("ValLabel", factor.letter[j])
      x2 <- paste(1:factor.levels[j], gsub(' ','',paste('\"',vl[[j]],'\"')))
      x <- paste(x1,paste(x2,collapse=' '))
      vallab.list <- c(vallab.list, x)
    }
  }
  value<-list("var.spec"=var.spec, "lab.spec"=lab.spec,"vallab.spec"=vallab.list)
}






.df.to.mim.old <- function(data){
  tmp <- proc.time()
  nt <- as.data.frame(data)
  vs <- .nt.to.varspec(nt)
  mdata <- observations(data)
  for (j in 1:ncol(mdata))
    mdata[,j] <- as.numeric(mdata[,j])
  str4     <- unlist( lapply( as.vector(t(mdata)), .float.to.string, n.digits=5, width=15))    
  var.letter <- .look.up.mim.names(names(mdata),nt,"to.mim")
    
  lapply(vs, mim.cmd)
  mim.cmd(paste("Read", paste(var.letter, collapse=' ')))
  lapply(.partition.mim.input(str4),mim.cmd)
  mim.cmd("!")
  cat("Time taken:", proc.time()-tmp,"\n")
}
