% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_data.R
\name{remove_singleton_columns}
\alias{remove_singleton_columns}
\title{Remove columns appearing in only \code{threshold} row(s) or fewer.}
\usage{
remove_singleton_columns(dat, threshold = 1)
}
\arguments{
\item{dat}{dataframe}

\item{threshold}{Number of rows. If a column only has non-zero & non-NA values
in \code{threshold} row(s) or fewer, it will be removed.}
}
\value{
dataframe without singleton columns
}
\description{
Removes columns which only have non-zero & non-NA values in \code{threshold} row(s) or fewer.
}
\examples{
remove_singleton_columns(data.frame(a = 1:3, b = c(0, 1, 0), c = 4:6))
remove_singleton_columns(data.frame(a = 1:3, b = c(0, 1, 0), c = 4:6), threshold = 0)
remove_singleton_columns(data.frame(a = 1:3, b = c(0, 1, NA), c = 4:6))
remove_singleton_columns(data.frame(a = 1:3, b = c(1, 1, 1), c = 4:6))
}
\author{
Kelly Sovacool, \email{sovacool@umich.edu}

Courtney Armour
}
