% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggraphgrid.R
\name{ggraphgrid}
\alias{ggraphgrid}
\title{Plot graph to grid}
\usage{
ggraphgrid(x, algorithm = c("kk", "fr"))
}
\arguments{
\item{x}{A migraph-consistent network/graph}

\item{algorithm}{An initial network layout,
currently either Kamada-Kawai ("kk") or
Fruchterman-Reingold ("fr")}
}
\description{
For quick and easy graphing of networks to a grid plot
}
\details{
The function uses approximate pattern matching
to redistributes the coarse layouts on the square grid points, while
preserving the topological relationships among the nodes (see Inoue et al. 2012).
}
\examples{
ggraphgrid(mpn_elite_mex)
ggraphgrid(mpn_elite_usa_advice)
ggraphgrid(mpn_elite_usa_money)
ggraphgrid(mpn_ryanair)
}
\references{
Inoue et al. (2012).
Application of Approximate Pattern Matching in Two Dimensional
Spaces to Grid Layout for Biochemical Network Maps.
PLoS One 7 (6): e37739. doi: https://doi.org/10.1371/journal.pone.0037739.
}
