% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_mpn.R
\docType{data}
\name{mpn_elite_usa}
\alias{mpn_elite_usa}
\alias{mpn_elite_usa_advice}
\alias{mpn_elite_usa_money}
\title{Two-mode and three-mode American power elite database (Domhoff 2016)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tbl_graph: 34 nodes and 46 edges
## #
## # A bipartite simple graph with 1 component
## #
## # Node Data: 34 × 2 (active)
##   type  name    
##   <lgl> <chr>   
## 1 FALSE Albright
## 2 FALSE Argyros 
## 3 FALSE Armitage
## 4 FALSE Curry   
## 5 FALSE Fukuyama
## 6 FALSE Gray    
## # … with 28 more rows
## #
## # Edge Data: 46 × 2
##    from    to
##   <int> <int>
## 1     1    17
## 2     1    19
## 3     1    21
## # … with 43 more rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tbl_graph: 38 nodes and 103 edges
## #
## # A bipartite simple graph with 1 component
## #
## # Node Data: 38 × 2 (active)
##   type  name    
##   <lgl> <chr>   
## 1 FALSE Adkerson
## 2 FALSE Akins   
## 3 FALSE Banga   
## 4 FALSE Boyce   
## 5 FALSE Britt   
## 6 FALSE Cannon  
## # … with 32 more rows
## #
## # Edge Data: 103 × 2
##    from    to
##   <int> <int>
## 1     1    27
## 2     1    28
## 3     1    34
## # … with 100 more rows
}\if{html}{\out{</div>}}
}
\usage{
data(mpn_elite_usa_advice)

data(mpn_elite_usa_money)
}
\description{
\code{mpn_elite_usa_advice} is a 2-mode network of persons serving as directors or trustees of think tanks.
Think tanks are “public-policy research analysis and engagement organizations
that generate policy-oriented research, analysis, and advice on domestic and international issues,
thereby enabling policymakers and the public to make informed decisions about public policy” (McGann 2016: 6).
The Power Elite Database (Domhoff 2016) includes information on the directors of 33 prominent think tanks in 2012.
Here we include only 14 directors who held three or more seats among 20 think tanks.

\code{mpn_elite_usa_money} is based on 26 elites who sat on the boards of directors
for at least two of six economic policy making organizations (Domhoff 2016),
and also made campaign contributions to one or more of six candidates
running in the primary election contests for the 2008 Presidential nominations
of the Republican Party (Rudy Giuliani, John McCain, Mitt Romney)
or the Democratic Party (Hillary Clinton, Christopher Dodd, Barack Obama).
}
\references{
Domhoff, G William. 2016. \href{https://whorulesamerica.ucsc.edu/power_elite/}{“Who Rules America? Power Elite Database.”}

The Center for Responsive Politics. 2019. \href{https://www.opensecrets.org}{“OpenSecrets.”}

Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021.
\href{https://www.cambridge.org/core/books/multimodal-political-networks/43EE8C192A1B0DCD65B4D9B9A7842128}{\emph{Multimodal Political Networks}}.
Cambridge University Press. Cambridge University Press.
}
\keyword{datasets}
