% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_networkers}
\alias{ison_networkers}
\title{One-mode EIES dataset (Freeman and Freeman 1979)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tbl_graph: 32 nodes and 440 edges
## #
## # A directed simple graph with 1 component
## #
## # Node Data: 32 × 3 (active)
##   name               Discipline   Citations
##   <chr>              <chr>            <dbl>
## 1 LIN FREEMAN        Sociology           19
## 2 DOUG WHITE         Anthropology         3
## 3 EV ROGERS          Other              170
## 4 RICHARD ALBA       Sociology           23
## 5 PHIPPS ARABIE      Other               16
## 6 CAROL BARNER-BARRY Other                6
## # … with 26 more rows
## #
## # Edge Data: 440 × 3
##    from    to weight
##   <int> <int>  <dbl>
## 1     1     2    488
## 2     1     3     28
## 3     1     4     65
## # … with 437 more rows
}\if{html}{\out{</div>}}
}
\source{
networkdata package
}
\usage{
data(ison_networkers)
}
\description{
A directed, simple, named, weighted graph with 32 nodes and 440
edges. Nodes are academics and edges illustrate the communication patterns
on an Electronic Information Exchange System among them. Node attributes
include the number of citations (\code{Citations}) and the discipline of the
researchers (\code{Discipline}). Edge weights illustrate the number of emails
sent from one academic to another over the studied time period.
}
\references{
Freeman, Sue C. and Linton C. Freeman. 1979.
\emph{The networkers network: A study of the impact of a new communications medium on sociometric structure}.
Social Science Research Reports No 46. Irvine CA, University of California.

Wasserman Stanley and Katherine Faust. 1994.
\emph{Social Network Analysis: Methods and Applications}.
Cambridge University Press, Cambridge.
}
\keyword{datasets}
