% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mifa-ci.R
\name{combine_rubin}
\alias{combine_rubin}
\title{Combine results from different imputations using Rubin's rules}
\usage{
combine_rubin(param_imps, cov_imps)
}
\arguments{
\item{param_imps}{Matrix containing estimated parameters in each imputation
as its rows.}

\item{cov_imps}{List of estimated covariance matrices for each imputation.}
}
\value{
A list:
\describe{
\item{param_est}{Vector of combined parameter estimates with the same length
as columns in \code{param_imps}.}
\item{cov_param}{Combined variance-covariance matrix of size n x n, where n
is the number of columns in \code{param_imps}.}
\item{between_cov}{Between imputations variance-covariance matrix of size
n x n, where n is the number of columns in \code{param_imps}.}
}
}
\description{
Applies Rubin's rules to combine estimates and
variance-covariance matrices from different imputations.
}
\references{
Rubin D. B. Multiple imputation for nonresponse in surveys (2004).
John Wiley & Sons.
}
\keyword{internal}
