% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_theme_info.R
\name{color.theme.info}
\alias{color.theme.info}
\alias{color.theme.env}
\title{Retrieve Color Theme Information}
\usage{
color.theme.info(env = color.theme.env())

color.theme.env()
}
\arguments{
\item{env}{an environment where the color themes are registered.}
}
\value{
\code{color.theme.info()} returns a data frame with columns "name", "source", and "type".

\code{color.theme.env()} returns the environment currently used as the default theme registry.
}
\description{
\code{color.theme.info()} returns a data frame listing all available color themes.

\code{color.theme.env()} provides direct access to the environment where the color themes are registered.
}
\details{
These functions provide tools for inspecting the color themes available in the current R session.

\code{color.theme.info()} is the primary user-facing function for discovering themes by name, source, and type.

\code{color.theme.env()} is an advanced function that returns the environment currently used as the theme registry.
It first checks for a user-specified environment via \code{getOption("midr.color.theme.env")}.
If this option is \code{NULL} (the default), the function returns the package's internal environment where the default themes are stored.
}
\examples{
# Get a data frame of all available themes
head(color.theme.info())

# Get the environment where color themes are stored
theme_env <- color.theme.env()
names(theme_env)[1:5]
}
\seealso{
\code{\link{color.theme}}, \code{\link{set.color.theme}}
}
