% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmid_mid_conditional.R
\name{ggmid.mid.conditional}
\alias{ggmid.mid.conditional}
\alias{autoplot.mid.conditional}
\title{Plot ICE of MID Model with ggplot2 Package}
\usage{
\method{ggmid}{mid.conditional}(
  object,
  type = c("iceplot", "centered"),
  theme = NULL,
  term = NULL,
  var.alpha = NULL,
  var.color = NULL,
  var.linetype = NULL,
  var.linewidth = NULL,
  reference = 1L,
  dots = TRUE,
  sample = NULL,
  ...
)

\method{autoplot}{mid.conditional}(object, ...)
}
\arguments{
\item{object}{a "mid.conditional" object to be visualized.}

\item{type}{a character string specifying the type of the plot. One of "iceplot" or "centered". If "centered", the ICE values of each observation are set to zero at the leftmost point of the varriable.}

\item{theme}{a character string specifying the color theme or any item that can be used to define "color.theme" object.}

\item{term}{an optional character string specifying an interaction term. If passed, the ICE curve for the specified term is plotted.}

\item{var.alpha}{a name of the variable or an expression to be used to set \code{alpha}.}

\item{var.color}{a name of the variable or an expression to be used to set \code{colour}.}

\item{var.linetype}{a name of the variable or an expression to be used to set \code{linetype}.}

\item{var.linewidth}{a name of the variable or an expression to be used to set \code{linewidth}.}

\item{reference}{an integer specifying the index of the sample points to be used as reference point for the centered ICE plot. Default is \code{1}. If negative, the maximum value of the variable is used.}

\item{dots}{logical. If \code{TRUE}, the points representing the predictions for each observation are plotted.}

\item{sample}{an optional vector specifying the names of observations to be plotted.}

\item{...}{optional parameters to be passed to the main layer.}
}
\value{
\code{ggmid.mid.conditional()} returns a "ggplot" object.
}
\description{
For "mid.conditional" objects, \code{ggmid()} visualizes ICE curves of a MID model.
}
\details{
The S3 method of \code{ggmid()} for "mid.conditional" objects creates a "ggplot" object that visualizes ICE curves of a fitted MID model using \code{geom_line()}.
}
\examples{
data(airquality, package = "datasets")
library(midr)
mid <- interpret(Ozone ~ .^2, airquality, lambda = 0.1)
ice <- mid.conditional(mid, "Temp", data = airquality)
ggmid(ice, var.color = "Wind")
ggmid(ice, type = "centered", theme = "Purple-Yellow",
      var.color = factor(Month), var.linetype = Wind > 10)
}
