% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midasqr.R
\name{midas_qr}
\alias{midas_qr}
\title{Restricted MIDAS quantile regression}
\usage{
midas_qr(
  formula,
  data,
  tau = 0.5,
  start,
  Ofunction = "nlrq",
  weight_gradients = NULL,
  guess_start = TRUE,
  ...
)
}
\arguments{
\item{formula}{formula for restricted MIDAS regression or \code{midas_qr} object. Formula must include \code{\link{mls}} function}

\item{data}{a named list containing data with mixed frequencies}

\item{tau}{quantile}

\item{start}{the starting values for optimisation. Must be a list with named elements.}

\item{Ofunction}{the list with information which R function to use for optimisation. The list must have element named \code{Ofunction} which contains character string of chosen R function. Other elements of the list are the arguments passed to this function.  The default optimisation function is \code{\link{optim}} with argument \code{method="BFGS"}. Other supported functions are \code{\link{nls}}}

\item{weight_gradients}{a named list containing gradient functions of weights. The weight gradient function must return the matrix with dimensions
\eqn{d_k \times q}, where \eqn{d_k} and \eqn{q} are the number of coefficients in unrestricted and restricted regressions correspondingly.
The names of the list should coincide with the names of weights used in formula.
The default value is NULL, which means that the numeric approximation of weight function gradient is calculated. If the argument is not NULL, but the
name of the weight used in formula is not present, it is assumed that there exists an R function which has  
the name of the weight function appended with \code{_gradient}.}

\item{guess_start, }{logical, if TRUE tries certain strategy to improve starting values}

\item{...}{additional arguments supplied to optimisation function}
}
\value{
a \code{midas_r} object which is the list with the following elements:

\item{coefficients}{the estimates of parameters of restrictions}
\item{midas_coefficients}{the estimates of MIDAS coefficients of MIDAS regression}
\item{model}{model data}
\item{unrestricted}{unrestricted regression estimated using \code{\link{midas_u}}}
\item{term_info}{the named list. Each element is a list with the information about the term, such as its frequency, function for weights, gradient function of weights, etc.}
\item{fn0}{optimisation function for non-linear least squares problem solved in restricted MIDAS regression}
\item{rhs}{the function which evaluates the right-hand side of the MIDAS regression}
\item{gen_midas_coef}{the function which generates the MIDAS coefficients of MIDAS regression}
\item{opt}{the output of optimisation procedure}
\item{argmap_opt}{the list containing the name of optimisation function together with arguments for optimisation function}
\item{start_opt}{the starting values used in optimisation}
\item{start_list}{the starting values as a list}
\item{call}{the call to the function}
\item{terms}{terms object}
\item{gradient}{gradient of NLS objective function}
\item{hessian}{hessian of NLS objective function}
\item{gradD}{gradient function of MIDAS weight functions} 
\item{Zenv}{the environment in which data is placed}
\item{use_gradient}{TRUE if user supplied gradient is used, FALSE otherwise}
\item{nobs}{the number of effective observations}
\item{convergence}{the convergence message}
\item{fitted.values}{the fitted values of MIDAS regression}
\item{residuals}{the residuals of MIDAS regression}
}
\description{
Estimate restricted MIDAS quantile regression using nonlinear quantile regression
}
\examples{
##Take the same example as in midas_r

theta_h0 <- function(p, dk, ...) {
   i <- (1:dk-1)/100
   pol <- p[3]*i + p[4]*i^2
   (p[1] + p[2]*i)*exp(pol)
}

##Generate coefficients
theta0 <- theta_h0(c(-0.1,10,-10,-10),4*12)

##Plot the coefficients
plot(theta0)

##Generate the predictor variable
xx <- ts(arima.sim(model = list(ar = 0.6), 600 * 12), frequency = 12)

##Simulate the response variable
y <- midas_sim(500, xx, theta0)

x <- window(xx, start=start(y))

##Fit quantile regression. All the coefficients except intercept should be constant.
##Intercept coefficient should correspond to quantile function of regression errors.
mr <- midas_qr(y~fmls(x,4*12-1,12,theta_h0), tau = c(0.1, 0.5, 0.9),
              list(y=y,x=x),
              start=list(x=c(-0.1,10,-10,-10)))
              
mr
}
\author{
Vaidotas Zemlys-Balevicius
}
