% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midasreg.R
\name{midas_r_plain}
\alias{midas_r_plain}
\title{Restricted MIDAS regression}
\usage{
midas_r_plain(y, X, z = NULL, weight, grw = NULL, startx,
  startz = NULL, method = c("Nelder-Mead", "BFGS"), ...)
}
\arguments{
\item{y}{model response}

\item{X}{prepared matrix of high frequency variable lags}

\item{z}{additional low frequency variables}

\item{weight}{the weight function}

\item{grw}{the gradient of weight function}

\item{startx}{the starting values for weight function}

\item{startz}{the starting values for additional low frequency variables}

\item{method}{a method passed to \link{optimx}}

\item{...}{additional parameters to \link{optimx}}
}
\value{
an object similar to \code{midas_r} object
}
\description{
Function for fitting MIDAS regression without the formula interface
}
\examples{

data("USunempr")
data("USrealgdp")
y <- diff(log(USrealgdp))
x <- window(diff(USunempr),start=1949)
trend <- 1:length(y)

X<-fmls(x,11,12)

midas_r_plain(y,X,trend,weight=nealmon,startx=c(0,0,0))
}
\author{
Virmantas Kvedaras, Vaidotas Zemlys
}
