% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orfs.R
\name{lorfs}
\alias{lorfs}
\title{Longest ORF}
\usage{
lorfs(gff.table)
}
\arguments{
\item{gff.table}{A \code{gff.table} (\code{data.frame}) with genomic features information.}
}
\value{
A \code{gff.table} with a subset of the rows of the argument \code{gff.table}. 
After this filtering the Type variable in \code{gff.table} is changed to \code{"LORF"}. If you want to
retirve the LORF sequences, use \code{\link{gff2fasta}}.
}
\description{
Filtering a \code{gff.table} with ORF information to keep only the LORFs.
}
\details{
For every stop-codon there are usually multiple possible start-codons in the same reading
frame (nested ORFs). The LORF (Longest ORF) is defined as the longest of these nested ORFs,
i.e. the ORF starting at the most upstream start-codon matching the stop-codon.
}
\examples{
# See the example in the Help-file for findOrfs.

}
\seealso{
\code{\link{readGFF}}, \code{\link{findOrfs}}, \code{\link{gff2fasta}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
