% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasta.R
\name{readFasta}
\alias{Fasta}
\alias{readFasta}
\alias{writeFasta}
\title{Read and write FASTA files}
\usage{
readFasta(in.file)
writeFasta(fdta, out.file, width = 80)
}
\arguments{
\item{in.file}{url/directory/name of FASTA file to read.}

\item{fdta}{A \samp{Fasta} object, see \sQuote{Details} below.}

\item{out.file}{Name of FASTA-file to create.}

\item{width}{Number of sequence characters per line.}
}
\value{
\code{\link{readFasta}} returns a \code{Fasta} object with the contents of the FASTA file. This is an
extension to a \code{data.frame} and contains two columns of text. The first, named \samp{Header}, contains
the headerlines and the second, named \samp{Sequence}, contains the sequences.

\code{\link{writeFasta}} produces a FASTA file.
}
\description{
Reads and writes biological sequences (DNA, RNA, protein) in the FASTA format.
}
\details{
These functions handle input/output of sequences in the commonly used FASTA format.
For every sequence it is presumed there is one Header-line starting with a \sQuote{>}.

The sequences are stored in a \code{Fasta} object. This is an extension of a \code{data.frame}
containing two text-columns named \samp{Header} and \samp{Sequence}. If other columns are
present, these will be ignored by \code{\link{writeFasta}}.

The \code{Fasta} object can be treated as a \code{data.frame}, but the generic functions \code{\link{plot.Fasta}}
and \code{\link{summary.Fasta}} are defined. The \code{data.frame} property makes it
straightforward to manipulate all headers or all sequences, or to extract or delete entries (rows), or to merge
several data sets using \code{\link{rbind}}.
}
\examples{
ex.file <- file.path(file.path(path.package("microseq"),"extdata"),"small.fasta")
fdta <- readFasta(ex.file)
summary(fdta)
plot(fdta)

}
\author{
Lars Snipen and Kristian Hovde Liland.
}
\seealso{
\code{\link{plot.Fasta}}, \code{\link{summary.Fasta}}, \code{\link{readFastq}}.
}
\keyword{FASTA}
\keyword{Fasta}
\keyword{sequence}

