% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multialign.R
\name{cmalign}
\alias{cmalign}
\title{Multiple alignment using Infernal}
\usage{
cmalign(in.file, out.file, CM.file, threads = 1)
}
\arguments{
\item{in.file}{Name of FASTA-file with input sequences.}

\item{out.file}{Name of file to store the result.}

\item{CM.file}{Name of file with correlation model.}

\item{threads}{Number of CPU's to use}
}
\value{
The result is written to the file specified in \code{out.file}.
}
\description{
Computing a multiple sequence alignment using the Infernal software.
}
\details{
The software Infernal (Nawrocki&Eddy, 2013) must be installed and available on the system. Test 
this by typing \code{system("cmalign -h")} in the Console, and some sensible output should be produced. 
For more details on Infernal, see http://eddylab.org/infernal/.

This function is most typically used to align 16S rRNA sequences.

The \code{cmalign} function will produce a multiple alignment, like e.g. \code{muscle}, but makes use
of a \emph{correlation model} to do so. A correlation model means in this case a description of
how various bases have a long-range relation, due to folding of the sequence. This means that you can
only use this function to align sequences for which you have such correlation models. Such models
are typically available for a number of RNA-families, see below. 

The argument \code{CM.file} is the name of a file with a valid correlation model, e.g. one downloaded
from the \href{http://rfam.xfam.org/}{Rfam database}. See examples below for the 16S model supplied with this
package.
}
\examples{
\dontrun{
in.file <- file.path(file.path(path.package("microseq"),"extdata"),"16S.fasta")
cm.file <- file.path(file.path(path.package("microseq"),"extdata"),"ssu_bacteria.cm")
cmalign(in.file,"msa_infernal.fasta",cm.file)
}


}
\author{
Lars Snipen.
}
\references{
E.P. Nawrocki and S.R. Eddy,  Infernal 1.1: 100-fold faster RNA homology searches, 
Bioinformatics 29:2933-2935 (2013).
}
\seealso{
\code{\link{msaTrim}}.
}

