% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_nullmodel.R
\name{trans_nullmodel}
\alias{trans_nullmodel}
\title{Create trans_nullmodel object for phylogeny- and taxonomy-based null model analysis.}
\description{
This class is a wrapper for a series of null model related approaches, 
including the mantel correlogram analysis of phylogenetic signal, beta nearest taxon index (betaNTI), 
beta net relatedness index (betaNRI), NTI, NRI and RCbray calculations;
See Stegen et al. (2013) <10.1038/ismej.2013.93> and Liu et al. (2017) <doi:10.1038/s41598-017-17736-w> for the algorithms and applications.
}
\examples{

## ------------------------------------------------
## Method `trans_nullmodel$new`
## ------------------------------------------------

data(dataset)
data(env_data_16S)
t1 <- trans_nullmodel$new(dataset, filter_thres = 0.0005, add_data = env_data_16S)

## ------------------------------------------------
## Method `trans_nullmodel$cal_mantel_corr`
## ------------------------------------------------

\donttest{
t1$cal_mantel_corr(use_env = "pH")
}

## ------------------------------------------------
## Method `trans_nullmodel$plot_mantel_corr`
## ------------------------------------------------

\donttest{
t1$plot_mantel_corr()
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_betampd`
## ------------------------------------------------

\donttest{
t1$cal_betampd(abundance.weighted = TRUE)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_betamntd`
## ------------------------------------------------

\donttest{
t1$cal_betamntd(abundance.weighted = TRUE)
t1$cal_betamntd(abundance.weighted = TRUE, use_iCAMP = TRUE)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_ses_betampd`
## ------------------------------------------------

\donttest{
t1$cal_ses_betampd(runs = 500, abundance.weighted = TRUE)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_ses_betamntd`
## ------------------------------------------------

\donttest{
t1$cal_ses_betamntd(runs = 500, abundance.weighted = TRUE, exclude.conspecifics = FALSE)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_rcbray`
## ------------------------------------------------

\donttest{
t1$cal_rcbray(runs = 500)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_process`
## ------------------------------------------------

\donttest{
t1$cal_process(use_betamntd = TRUE)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_NRI`
## ------------------------------------------------

\dontrun{
t1$cal_NRI()
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_NTI`
## ------------------------------------------------

\dontrun{
t1$cal_NTI(null.model = "taxa.labels", abundance.weighted = TRUE)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_Cscore`
## ------------------------------------------------

\dontrun{
t1$cal_Cscore()
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{trans_nullmodel$new()}}
\item \href{#method-cal_mantel_corr}{\code{trans_nullmodel$cal_mantel_corr()}}
\item \href{#method-plot_mantel_corr}{\code{trans_nullmodel$plot_mantel_corr()}}
\item \href{#method-cal_betampd}{\code{trans_nullmodel$cal_betampd()}}
\item \href{#method-cal_betamntd}{\code{trans_nullmodel$cal_betamntd()}}
\item \href{#method-cal_ses_betampd}{\code{trans_nullmodel$cal_ses_betampd()}}
\item \href{#method-cal_ses_betamntd}{\code{trans_nullmodel$cal_ses_betamntd()}}
\item \href{#method-cal_rcbray}{\code{trans_nullmodel$cal_rcbray()}}
\item \href{#method-cal_process}{\code{trans_nullmodel$cal_process()}}
\item \href{#method-cal_NRI}{\code{trans_nullmodel$cal_NRI()}}
\item \href{#method-cal_NTI}{\code{trans_nullmodel$cal_NTI()}}
\item \href{#method-cal_Cscore}{\code{trans_nullmodel$cal_Cscore()}}
\item \href{#method-clone}{\code{trans_nullmodel$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$new(
  dataset = NULL,
  filter_thres = 0,
  taxa_number = NULL,
  group = NULL,
  select_group = NULL,
  env_cols = NULL,
  add_data = NULL,
  complete_na = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{filter_thres}}{default 0; the relative abundance threshold.}

\item{\code{taxa_number}}{default NULL; how many taxa the user want to keep, if provided, filter_thres parameter will be forcible invalid.}

\item{\code{group}}{default NULL; which group column name in sample_table is selected.}

\item{\code{select_group}}{default NULL; the group name, used following the group parameter to filter samples.}

\item{\code{env_cols}}{default NULL; number or name vector to select the environmental data in dataset$sample_table.}

\item{\code{add_data}}{default NULL; provide environmental data table additionally.}

\item{\code{complete_na}}{default FALSE; whether fill the NA in environmental data based on the method in mice package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
comm and phylo_tree in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(dataset)
data(env_data_16S)
t1 <- trans_nullmodel$new(dataset, filter_thres = 0.0005, add_data = env_data_16S)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_mantel_corr"></a>}}
\if{latex}{\out{\hypertarget{method-cal_mantel_corr}{}}}
\subsection{Method \code{cal_mantel_corr()}}{
Calculate mantel correlogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_mantel_corr(
  use_env = NULL,
  break.pts = seq(0, 1, 0.02),
  cutoff = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_env}}{default NULL; numeric or character vector to select env_data; if provide multiple variables or NULL, 
use PCA (principal component analysis) to reduce dimensionality.}

\item{\code{break.pts}}{default seq(0, 1, 0.02); see break.pts parameter in \code{\link{mantel.correlog}} of vegan package.}

\item{\code{cutoff}}{default FALSE; see cutoff parameter in \code{\link{mantel.correlog}}.}

\item{\code{...}}{parameters pass to \code{\link{mantel.correlog}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_mantel_corr in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_mantel_corr(use_env = "pH")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_mantel_corr"></a>}}
\if{latex}{\out{\hypertarget{method-plot_mantel_corr}{}}}
\subsection{Method \code{plot_mantel_corr()}}{
Plot mantel correlogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$plot_mantel_corr(point_shape = 22, point_size = 3)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point_shape}}{default 22; the number for selecting point shape type; see ggplot2 manual for the number meaning.}

\item{\code{point_size}}{default 3; the point size.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_mantel_corr()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_betampd"></a>}}
\if{latex}{\out{\hypertarget{method-cal_betampd}{}}}
\subsection{Method \code{cal_betampd()}}{
Calculate betaMPD (mean pairwise distance). Same with comdist in picante package, but faster.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_betampd(abundance.weighted = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abundance.weighted}}{default TRUE; whether use abundance-weighted method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_betampd in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_betampd(abundance.weighted = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_betamntd"></a>}}
\if{latex}{\out{\hypertarget{method-cal_betamntd}{}}}
\subsection{Method \code{cal_betamntd()}}{
Calculate betaMNTD (mean nearest taxon distance). Same with comdistnt in picante package, but faster.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_betamntd(
  abundance.weighted = TRUE,
  exclude.conspecifics = FALSE,
  use_iCAMP = FALSE,
  use_iCAMP_force = TRUE,
  iCAMP_tempdir = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abundance.weighted}}{default TRUE; whether use abundance-weighted method.}

\item{\code{exclude.conspecifics}}{default FALSE; see exclude.conspecifics parameter in comdistnt function of picante package.}

\item{\code{use_iCAMP}}{default FALSE; whether use bmntd.big function of iCAMP package to calculate betaMNTD. 
This method can store the phylogenetic distance matrix on the disk to lower the memory spending and perform the calculation parallelly.}

\item{\code{use_iCAMP_force}}{default FALSE; whether use bmntd.big function of iCAMP package automatically when the feature number is large.}

\item{\code{iCAMP_tempdir}}{default NULL; the temporary directory used to place the large tree file; If NULL; use the system user tempdir.}

\item{\code{...}}{paremeters pass to iCAMP::pdist.big function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_betamntd in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_betamntd(abundance.weighted = TRUE)
t1$cal_betamntd(abundance.weighted = TRUE, use_iCAMP = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_ses_betampd"></a>}}
\if{latex}{\out{\hypertarget{method-cal_ses_betampd}{}}}
\subsection{Method \code{cal_ses_betampd()}}{
Calculate standardized effect size of betaMPD, i.e. beta net relatedness index (betaNRI).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_ses_betampd(
  runs = 1000,
  null.model = c("taxa.labels", "richness", "frequency", "sample.pool",
    "phylogeny.pool", "independentswap", "trialswap")[1],
  abundance.weighted = TRUE,
  iterations = 1000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{runs}}{default 1000; simulation runs.}

\item{\code{null.model}}{default "taxa.labels"; The available options include "taxa.labels", "richness", "frequency", "sample.pool", "phylogeny.pool", 
"independentswap"and "trialswap"; see null.model parameter of ses.mntd function in picante package for the algorithm details.}

\item{\code{abundance.weighted}}{default TRUE; whether use weighted abundance.}

\item{\code{iterations}}{default 1000; iteration number for part null models to perform; see iterations parameter of picante::randomizeMatrix function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_ses_betampd in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ses_betampd(runs = 500, abundance.weighted = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_ses_betamntd"></a>}}
\if{latex}{\out{\hypertarget{method-cal_ses_betamntd}{}}}
\subsection{Method \code{cal_ses_betamntd()}}{
Calculate standardized effect size of betaMNTD, i.e. beta nearest taxon index (betaNTI).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_ses_betamntd(
  runs = 1000,
  null.model = c("taxa.labels", "richness", "frequency", "sample.pool",
    "phylogeny.pool", "independentswap", "trialswap")[1],
  abundance.weighted = TRUE,
  exclude.conspecifics = FALSE,
  use_iCAMP = FALSE,
  use_iCAMP_force = TRUE,
  iCAMP_tempdir = NULL,
  nworker = 2,
  iterations = 1000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{runs}}{default 1000; simulation number of null model.}

\item{\code{null.model}}{default "taxa.labels"; The available options include "taxa.labels", "richness", "frequency", "sample.pool", "phylogeny.pool", 
"independentswap"and "trialswap"; see null.model parameter of ses.mntd function in picante package for the algorithm details.}

\item{\code{abundance.weighted}}{default TRUE; whether use abundance-weighted method.}

\item{\code{exclude.conspecifics}}{default FALSE; see comdistnt in picante package.}

\item{\code{use_iCAMP}}{default FALSE; whether use bmntd.big function of iCAMP package to calculate betaMNTD. 
This method can store the phylogenetic distance matrix on the disk to lower the memory spending and perform the calculation parallelly.}

\item{\code{use_iCAMP_force}}{default FALSE; whether to make use_iCAMP to be TRUE when the feature number is large.}

\item{\code{iCAMP_tempdir}}{default NULL; the temporary directory used to place the large tree file; If NULL; use the system user tempdir.}

\item{\code{nworker}}{default 2; the CPU thread number.}

\item{\code{iterations}}{default 1000; iteration number for part null models to perform; see iterations parameter of picante::randomizeMatrix function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_ses_betamntd in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ses_betamntd(runs = 500, abundance.weighted = TRUE, exclude.conspecifics = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_rcbray"></a>}}
\if{latex}{\out{\hypertarget{method-cal_rcbray}{}}}
\subsection{Method \code{cal_rcbray()}}{
Calculate Bray–Curtis-based Raup–Crick (RCbray).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_rcbray(
  runs = 1000,
  verbose = TRUE,
  null.model = "independentswap"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{runs}}{default 1000; simulation runs.}

\item{\code{verbose}}{default TRUE; whether show the calculation process message.}

\item{\code{null.model}}{default "independentswap"; see more available options in randomizeMatrix function of picante package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_rcbray in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_rcbray(runs = 500)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_process"></a>}}
\if{latex}{\out{\hypertarget{method-cal_process}{}}}
\subsection{Method \code{cal_process()}}{
Infer the ecological processes according to ses.betaMNTD ses.betaMPD and rcbray.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_process(use_betamntd = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_betamntd}}{default TRUE; whether use ses.betaMNTD; if false, use ses.betaMPD.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_rcbray in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_process(use_betamntd = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_NRI"></a>}}
\if{latex}{\out{\hypertarget{method-cal_NRI}{}}}
\subsection{Method \code{cal_NRI()}}{
Calculates Nearest Relative Index (NRI), equivalent to -1 times the standardized effect size of MPD.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_NRI(
  null.model = "taxa.labels",
  abundance.weighted = FALSE,
  runs = 999,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{null.model}}{default "taxa.labels"; Null model to use; see null.model parameter in ses.mpd function of picante package for available options.}

\item{\code{abundance.weighted}}{default FALSE; Should mean nearest relative distances for each species be weighted by species abundance?}

\item{\code{runs}}{default 999; Number of randomizations.}

\item{\code{...}}{paremeters pass to ses.mpd function in picante package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_NRI in object, equivalent to -1 times ses.mpd.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1$cal_NRI()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_NTI"></a>}}
\if{latex}{\out{\hypertarget{method-cal_NTI}{}}}
\subsection{Method \code{cal_NTI()}}{
Calculates Nearest Taxon Index (NTI), equivalent to -1 times the standardized effect size of MNTD.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_NTI(
  null.model = "taxa.labels",
  abundance.weighted = FALSE,
  runs = 999,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{null.model}}{default "taxa.labels"; Null model to use; see null.model parameter in ses.mntd function of picante package for available options.}

\item{\code{abundance.weighted}}{default FALSE; Should mean nearest taxon distances for each species be weighted by species abundance?}

\item{\code{runs}}{default 999; Number of randomizations.}

\item{\code{...}}{paremeters pass to ses.mntd function in picante package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_NTI in object, equivalent to -1 times ses.mntd.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1$cal_NTI(null.model = "taxa.labels", abundance.weighted = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_Cscore"></a>}}
\if{latex}{\out{\hypertarget{method-cal_Cscore}{}}}
\subsection{Method \code{cal_Cscore()}}{
Calculates the (normalised) mean number of checkerboard combinations (C-score) using C.score function in bipartite package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_Cscore(by_group = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{by_group}}{default NULL; one column name or number in sample_table; calculate C-score for different groups separately.}

\item{\code{...}}{paremeters pass to C.score function in bipartite package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
results directly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1$cal_Cscore()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
