% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_network.R
\name{trans_network}
\alias{trans_network}
\title{Create trans_network object for co-occurrence network analysis.}
\description{
This class is a wrapper for a series of network analysis methods, 
including the network construction approaches, network attributes analysis,
eigengene analysis, network subsetting, node and edge properties extraction, network plotting, and other network operations.
}
\examples{

## ------------------------------------------------
## Method `trans_network$new`
## ------------------------------------------------

\donttest{
data(dataset)
# for correlation network
t1 <- trans_network$new(dataset = dataset, cal_cor = "base", 
		taxa_level = "OTU", filter_thres = 0.0001)
# for other network
t1 <- trans_network$new(dataset = dataset, cal_cor = NULL)
}

## ------------------------------------------------
## Method `trans_network$cal_network`
## ------------------------------------------------

\donttest{
# for correlation network
t1 <- trans_network$new(dataset = dataset, cal_cor = "base", 
		taxa_level = "OTU", filter_thres = 0.001)
t1$cal_network(COR_p_thres = 0.05, COR_cut = 0.6)
t1 <- trans_network$new(dataset = dataset, cal_cor = NULL, filter_thres = 0.003)
t1$cal_network(network_method = "SpiecEasi", SpiecEasi_method = "mb")
t1 <- trans_network$new(dataset = dataset, cal_cor = NULL, taxa_level = "OTU", filter_thres = 0.005)
t1$cal_network(network_method = "beemStatic")
t1 <- trans_network$new(dataset = dataset, cal_cor = NULL, filter_thres = 0.001)
t1$cal_network(network_method = "FlashWeave")
}

## ------------------------------------------------
## Method `trans_network$cal_module`
## ------------------------------------------------

\donttest{
t1 <- trans_network$new(dataset = dataset, cal_cor = "base", 
		taxa_level = "OTU", filter_thres = 0.0002)
t1$cal_network(COR_p_thres = 0.01, COR_cut = 0.6)
t1$cal_module(method = "cluster_fast_greedy")
}

## ------------------------------------------------
## Method `trans_network$save_network`
## ------------------------------------------------

\dontrun{
t1$save_network(filepath = "network.gexf")
}

## ------------------------------------------------
## Method `trans_network$cal_network_attr`
## ------------------------------------------------

\donttest{
t1$cal_network_attr()
}

## ------------------------------------------------
## Method `trans_network$get_node_table`
## ------------------------------------------------

\donttest{
t1$get_node_table(node_roles = TRUE)
}

## ------------------------------------------------
## Method `trans_network$get_edge_table`
## ------------------------------------------------

\donttest{
t1$get_edge_table()
}

## ------------------------------------------------
## Method `trans_network$get_adjacency_matrix`
## ------------------------------------------------

\donttest{
t1$get_adjacency_matrix(attr = "weight")
}

## ------------------------------------------------
## Method `trans_network$plot_network`
## ------------------------------------------------

\donttest{
t1$plot_network(method = "igraph", layout = layout_with_kk)
t1$plot_network(method = "ggraph", node_color = "module")
t1$plot_network(method = "networkD3", node_color = "module")
}

## ------------------------------------------------
## Method `trans_network$cal_eigen`
## ------------------------------------------------

\donttest{
t1$cal_eigen()
}

## ------------------------------------------------
## Method `trans_network$plot_taxa_roles`
## ------------------------------------------------

\donttest{
t1$plot_taxa_roles(roles_color_background = FALSE)
}

## ------------------------------------------------
## Method `trans_network$subset_network`
## ------------------------------------------------

\donttest{
t1$subset_network(node = t1$res_node_table \%>\% base::subset(module == "M1") \%>\% 
  rownames, rm_single = TRUE)
# return a sub network that contains all nodes of module M1
}

## ------------------------------------------------
## Method `trans_network$cal_powerlaw`
## ------------------------------------------------

\donttest{
t1$cal_powerlaw()
}

## ------------------------------------------------
## Method `trans_network$trans_comm`
## ------------------------------------------------

\donttest{
t2 <- t1$trans_comm(use_col = "module")
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{trans_network$new()}}
\item \href{#method-cal_network}{\code{trans_network$cal_network()}}
\item \href{#method-cal_module}{\code{trans_network$cal_module()}}
\item \href{#method-save_network}{\code{trans_network$save_network()}}
\item \href{#method-cal_network_attr}{\code{trans_network$cal_network_attr()}}
\item \href{#method-cal_node_type}{\code{trans_network$cal_node_type()}}
\item \href{#method-get_node_table}{\code{trans_network$get_node_table()}}
\item \href{#method-get_edge_table}{\code{trans_network$get_edge_table()}}
\item \href{#method-get_adjacency_matrix}{\code{trans_network$get_adjacency_matrix()}}
\item \href{#method-plot_network}{\code{trans_network$plot_network()}}
\item \href{#method-cal_eigen}{\code{trans_network$cal_eigen()}}
\item \href{#method-plot_taxa_roles}{\code{trans_network$plot_taxa_roles()}}
\item \href{#method-subset_network}{\code{trans_network$subset_network()}}
\item \href{#method-cal_powerlaw}{\code{trans_network$cal_powerlaw()}}
\item \href{#method-trans_comm}{\code{trans_network$trans_comm()}}
\item \href{#method-print}{\code{trans_network$print()}}
\item \href{#method-clone}{\code{trans_network$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
This function is used to create the trans_network object, store the important intermediate data 
  and calculate correlations if cal_cor parameter is selected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$new(
  dataset = NULL,
  cor_method = c("pearson", "spearman", "kendall")[1],
  cal_cor = c("base", "WGCNA", "SparCC", NULL)[1],
  taxa_level = "OTU",
  filter_thres = 0,
  nThreads = 1,
  SparCC_simu_num = 100,
  env_cols = NULL,
  add_data = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{cor_method}}{default "pearson"; "pearson", "spearman" or "kendall"; correlation algorithm, only use for correlation-based network.}

\item{\code{cal_cor}}{default "base"; "base", "WGCNA", "SparCC" or NULL; correlation method; NULL denote no correlation calculation, 
used for non-correlation based network, such as SpiecEasi and FlashWeave methods.}

\item{\code{taxa_level}}{default "OTU"; taxonomic rank; 'OTU' denotes using feature table directly; 
other available options should be one of the colnames of microtable$tax_table.}

\item{\code{filter_thres}}{default 0; the relative abundance threshold.}

\item{\code{nThreads}}{default 1; the thread number used for "WGCNA" and SparCC.}

\item{\code{SparCC_simu_num}}{default 100; SparCC simulation number for bootstrap.}

\item{\code{env_cols}}{default NULL; numeric or character vector to select the column names of environmental data in dataset$sample_table;
the environmental data can be used in the correlation network (as the nodes) or FlashWeave network.}

\item{\code{add_data}}{default NULL; provide environmental table additionally instead of env_cols parameter; rownames must be sample names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_cor_p list; include the correlation matrix and p value matrix.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(dataset)
# for correlation network
t1 <- trans_network$new(dataset = dataset, cal_cor = "base", 
		taxa_level = "OTU", filter_thres = 0.0001)
# for other network
t1 <- trans_network$new(dataset = dataset, cal_cor = NULL)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_network"></a>}}
\if{latex}{\out{\hypertarget{method-cal_network}{}}}
\subsection{Method \code{cal_network()}}{
Calculate network based on the correlation method or SpiecEasi package or julia FlashWeave package or beemStatic package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_network(
  network_method = c("COR", "SpiecEasi", "FlashWeave", "beemStatic")[1],
  COR_p_thres = 0.01,
  COR_p_adjust = "fdr",
  COR_weight = TRUE,
  COR_cut = 0.6,
  COR_optimization = FALSE,
  COR_optimization_low_high = c(0.4, 0.8),
  SpiecEasi_method = "mb",
  FlashWeave_tempdir = NULL,
  FlashWeave_meta_data = FALSE,
  FlashWeave_other_para = "alpha=0.01,sensitive=true,heterogeneous=true",
  beemStatic_t_strength = 0.001,
  beemStatic_t_stab = 0.8,
  add_taxa_name = "Phylum",
  usename_rawtaxa_when_taxalevel_notOTU = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network_method}}{default "COR"; "COR", "SpiecEasi", "FlashWeave" or "beemStatic"; The option details: 
\describe{
  \item{\strong{'COR'}}{correlation-based network; use the correlation and p value matrixes in object$res_cor_p returned from trans_network$new; 
        See Deng et al. (2012) <doi:10.1186/1471-2105-13-113> for other details}
  \item{\strong{'SpiecEasi'}}{SpiecEasi network; relies on algorithms for sparse neighborhood and inverse covariance selection;
        belong to the category of conditional dependence and graphical models;
        see \href{https://github.com/zdk123/SpiecEasi}{https://github.com/zdk123/SpiecEasi} for installing the R package; 
        see Kurtz et al. (2015) <doi:10.1371/journal.pcbi.1004226> for the algorithm details}
  \item{\strong{'FlashWeave'}}{FlashWeave network; Local-to-global learning framework; belong to the category of conditional dependence and graphical models;
     good performance on heterogenous datasets to find direct associations among taxa;
     see \href{https://github.com/meringlab/FlashWeave.jl}{https://github.com/meringlab/FlashWeave.jl} for installing julia language and FlashWeave package;
     julia must be in the computer system env path, otherwise the program can not find julia;
     see Tackmann et al. (2019) <doi:10.1016/j.cels.2019.08.002> for the algorithm details}
  \item{\strong{'beemStatic'}}{beemStatic network;
     extend generalized Lotka-Volterra model to cases of cross-sectional datasets to infer interaction among taxa based on expectation-maximization algorithm;
     see \href{https://github.com/CSB5/BEEM-static}{https://github.com/CSB5/BEEM-static} for installing the R package;
     see Li et al. (2021) <doi:10.1371/journal.pcbi.1009343> for algorithm details}
}}

\item{\code{COR_p_thres}}{default 0.01; the p value threshold for the correlation-based network.}

\item{\code{COR_p_adjust}}{default "fdr"; p value adjustment method, see method of p.adjust function for available options.}

\item{\code{COR_weight}}{default TRUE; whether use correlation coefficient as the weight of edges; FALSE represents weight = 1 for all edges.}

\item{\code{COR_cut}}{default 0.6; correlation coefficient threshold for the correlation network.}

\item{\code{COR_optimization}}{default FALSE; whether use random matrix theory (RMT) based method to determine the correlation coefficient; 
see https://doi.org/10.1186/1471-2105-13-113}

\item{\code{COR_optimization_low_high}}{default c(0.4, 0.8); the low and high value threshold used for the RMT optimization; only useful when COR_optimization = TRUE.}

\item{\code{SpiecEasi_method}}{default "mb"; either 'glasso' or 'mb';see spiec.easi function in package SpiecEasi and https://github.com/zdk123/SpiecEasi.}

\item{\code{FlashWeave_tempdir}}{default NULL; The temporary directory used to save the temporary files for running FlashWeave; If not assigned, use the system user temp.}

\item{\code{FlashWeave_meta_data}}{default FALSE; whether use env data for the optimization, If TRUE, the function automatically find the object$env_data in the object and
generate a file for meta_data_path parameter of FlashWeave.}

\item{\code{FlashWeave_other_para}}{default "alpha=0.01,sensitive=true,heterogeneous=true"; the parameters used for FlashWeave;
user can change the parameters or add more according to FlashWeave help document;
An exception is meta_data_path parameter as it is generated based on the data inside the object, see FlashWeave_meta_data parameter for the description.}

\item{\code{beemStatic_t_strength}}{default 0.001; for network_method = "beemStatic"; the threshold used to limit the number of interactions (strength);
same with the t.strength parameter in showInteraction function of beemStatic package.}

\item{\code{beemStatic_t_stab}}{default 0.8; for network_method = "beemStatic"; 
the threshold used to limit the number of interactions (stability); same with the t.stab parameter in showInteraction function of beemStatic package.}

\item{\code{add_taxa_name}}{default "Phylum"; one or more taxonomic rank name; used to add taxonomic rank name to network node properties.}

\item{\code{usename_rawtaxa_when_taxalevel_notOTU}}{default FALSE; whether replace the name of nodes using the taxonomic information.}

\item{\code{...}}{paremeters pass to spiec.easi function of SpiecEasi package when network_method = "SpiecEasi" or 
func.EM function of beemStatic package when network_method = "beemStatic".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_network stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
# for correlation network
t1 <- trans_network$new(dataset = dataset, cal_cor = "base", 
		taxa_level = "OTU", filter_thres = 0.001)
t1$cal_network(COR_p_thres = 0.05, COR_cut = 0.6)
t1 <- trans_network$new(dataset = dataset, cal_cor = NULL, filter_thres = 0.003)
t1$cal_network(network_method = "SpiecEasi", SpiecEasi_method = "mb")
t1 <- trans_network$new(dataset = dataset, cal_cor = NULL, taxa_level = "OTU", filter_thres = 0.005)
t1$cal_network(network_method = "beemStatic")
t1 <- trans_network$new(dataset = dataset, cal_cor = NULL, filter_thres = 0.001)
t1$cal_network(network_method = "FlashWeave")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_module"></a>}}
\if{latex}{\out{\hypertarget{method-cal_module}{}}}
\subsection{Method \code{cal_module()}}{
Calculate network modules and add module names to the network node properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_module(
  method = "cluster_fast_greedy",
  module_name_prefix = "M"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default "cluster_fast_greedy"; the method used to find the optimal community structure of a graph;
the following are available functions (options) from igraph package: "cluster_fast_greedy", "cluster_optimal",
"cluster_edge_betweenness", "cluster_infomap", "cluster_label_prop", "cluster_leading_eigen",
"cluster_louvain", "cluster_spinglass", "cluster_walktrap". 
For the details of these functions, see the help document, such as help(cluster_fast_greedy);
Note that the default "cluster_fast_greedy" method can only be used for undirected network. 
If the user selects network_method = "beemStatic" in cal_network function or provides other directed network, 
please use cluster_optimal or others for the modules identification.}

\item{\code{module_name_prefix}}{default "M"; the prefix of module names; module names are made of the module_name_prefix and numbers;
numbers are assigned according to the sorting result of node numbers in modules with decreasing trend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_network with modules, stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1 <- trans_network$new(dataset = dataset, cal_cor = "base", 
		taxa_level = "OTU", filter_thres = 0.0002)
t1$cal_network(COR_p_thres = 0.01, COR_cut = 0.6)
t1$cal_module(method = "cluster_fast_greedy")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_network"></a>}}
\if{latex}{\out{\hypertarget{method-save_network}{}}}
\subsection{Method \code{save_network()}}{
Save network as gexf style, which can be opened by Gephi (\href{https://gephi.org/}{https://gephi.org/}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$save_network(filepath = "network.gexf")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filepath}}{default "network.gexf"; file path to save the network.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1$save_network(filepath = "network.gexf")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_network_attr"></a>}}
\if{latex}{\out{\hypertarget{method-cal_network_attr}{}}}
\subsection{Method \code{cal_network_attr()}}{
Calculate network properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_network_attr()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
res_network_attr stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_network_attr()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_node_type"></a>}}
\if{latex}{\out{\hypertarget{method-cal_node_type}{}}}
\subsection{Method \code{cal_node_type()}}{
Calculate node properties. This function will be deprecated in the next release! Please use get_node_table function!
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_node_type()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
see the Return part in function get_node_table.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_node_table"></a>}}
\if{latex}{\out{\hypertarget{method-get_node_table}{}}}
\subsection{Method \code{get_node_table()}}{
Get the node property table. The properties may include the node names, modules allocation, degree, betweenness, abundance, 
  taxonomy, within-module connectivity and among-module connectivity <doi:10.1016/j.geoderma.2022.115866>.

Authors: Chi Liu, Umer Zeeshan Ijaz
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$get_node_table(node_roles = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{node_roles}}{default TRUE; whether calculate node roles, i.e. Module hubs, Network hubs, Connectors and Peripherals <doi:10.1016/j.geoderma.2022.115866>.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_node_table in object; Abundance expressed as a percentage; z denotes within-module connectivity;
  p denotes among-module connectivity.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$get_node_table(node_roles = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_edge_table"></a>}}
\if{latex}{\out{\hypertarget{method-get_edge_table}{}}}
\subsection{Method \code{get_edge_table()}}{
Get the edge property table, including connected nodes, label and weight.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$get_edge_table()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
res_edge_table in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$get_edge_table()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_adjacency_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-get_adjacency_matrix}{}}}
\subsection{Method \code{get_adjacency_matrix()}}{
Get the adjacency matrix from the network graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$get_adjacency_matrix(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters passed to as_adjacency_matrix function of igraph package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_adjacency_matrix in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$get_adjacency_matrix(attr = "weight")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_network"></a>}}
\if{latex}{\out{\hypertarget{method-plot_network}{}}}
\subsection{Method \code{plot_network()}}{
Plot the network based on a series of methods from other packages, such as igraph, ggraph and networkD3. 
The networkD3 package provides dynamic network. It is especially useful for a glimpse of the whole network structure and finding 
the interested nodes and edges in a large network. In contrast, the igraph and ggraph methods are suitable for relatively small network.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$plot_network(
  method = c("igraph", "ggraph", "networkD3")[1],
  node_label = "name",
  node_color = NULL,
  ggraph_layout = "fr",
  ggraph_node_size = 2,
  ggraph_text_color = NULL,
  ggraph_text_size = 3,
  networkD3_node_legend = TRUE,
  networkD3_zoom = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default "igraph"; The available options:
\describe{
  \item{\strong{'igraph'}}{call plot.igraph function in igraph package for a static network; see plot.igraph for the parameters}
  \item{\strong{'ggraph'}}{call ggraph function in ggraph package for a static network}
  \item{\strong{'networkD3'}}{use forceNetwork function in networkD3 package for a dynamic network; see forceNetwork function for the parameters}
}}

\item{\code{node_label}}{default "name"; node label shown in the plot for method = "ggraph" or method = "networkD3"; 
Please see the column names of object$res_node_table, which is the returned table of function object$get_node_table;
User can select other column names in res_node_table.}

\item{\code{node_color}}{default NULL; node color assignment for method = "ggraph" or method = "networkD3"; 
Select a column name of object$res_node_table, such as "module".}

\item{\code{ggraph_layout}}{default "fr"; for method = "ggraph"; see layout parameter of create_layout function in ggraph package.}

\item{\code{ggraph_node_size}}{default 2; for method = "ggraph"; the node size.}

\item{\code{ggraph_text_color}}{default NULL; for method = "ggraph"; a column name of object$res_node_table;
User can select other column names or change the content of object$res_node_table.}

\item{\code{ggraph_text_size}}{default 3; for method = "ggraph"; the node label text size.}

\item{\code{networkD3_node_legend}}{default TRUE; used for method = "networkD3"; logical value to enable node colour legends;
Please see the legend parameter in networkD3::forceNetwork function.}

\item{\code{networkD3_zoom}}{default TRUE; used for method = "networkD3"; logical value to enable (TRUE) or disable (FALSE) zooming;
Please see the zoom parameter in networkD3::forceNetwork function.}

\item{\code{...}}{parameters passed to plot.igraph function when method = "igraph" or forceNetwork function when method = "networkD3".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
network plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_network(method = "igraph", layout = layout_with_kk)
t1$plot_network(method = "ggraph", node_color = "module")
t1$plot_network(method = "networkD3", node_color = "module")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_eigen"></a>}}
\if{latex}{\out{\hypertarget{method-cal_eigen}{}}}
\subsection{Method \code{cal_eigen()}}{
Calculate eigengenes of modules, i.e. the first principal component based on PCA analysis, and the percentage of variance <doi:10.1186/1471-2105-13-113>.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_eigen()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
res_eigen and res_eigen_expla in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_eigen()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_taxa_roles"></a>}}
\if{latex}{\out{\hypertarget{method-plot_taxa_roles}{}}}
\subsection{Method \code{plot_taxa_roles()}}{
Plot the classification and importance of nodes, see object$res_node_table for the variable names used in the parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$plot_taxa_roles(
  use_type = c(1, 2)[1],
  roles_color_background = FALSE,
  roles_color_values = NULL,
  plot_module = FALSE,
  x_lim = c(0, 1),
  use_level = "Phylum",
  show_value = c("z", "p"),
  show_number = 1:10,
  plot_color = "Phylum",
  plot_shape = "taxa_roles",
  plot_size = "Abundance",
  color_values = RColorBrewer::brewer.pal(12, "Paired"),
  shape_values = c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_type}}{default 1; 1 or 2; 1 represents taxa roles area plot; 2 represents the layered plot with taxa as x axis.}

\item{\code{roles_color_background}}{default FALSE; for use_type=1; TRUE: use background colors for each area; FALSE: use classic point colors.}

\item{\code{roles_color_values}}{default NULL; for use_type=1; color palette for background or points.}

\item{\code{plot_module}}{default FALSE; for use_type=1; whether plot the modules information.}

\item{\code{x_lim}}{default c(0, 1); for use_type=1; x axis range when roles_color_background = FALSE.}

\item{\code{use_level}}{default "Phylum"; for use_type=2; used taxonomic level in x axis.}

\item{\code{show_value}}{default c("z", "p"); for use_type=2; used variable in y axis.}

\item{\code{show_number}}{default 1:10; for use_type=2; showed number in x axis, sorting according to the nodes number.}

\item{\code{plot_color}}{default "Phylum"; for use_type=2; used variable for color.}

\item{\code{plot_shape}}{default "taxa_roles"; for use_type=2; used variable for shape.}

\item{\code{plot_size}}{default "Abundance"; for use_type=2; used for point size; a fixed number (e.g. 5) is also available.}

\item{\code{color_values}}{default RColorBrewer::brewer.pal(12, "Paired"); for use_type=2; color vector}

\item{\code{shape_values}}{default c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14); for use_type=2; shape vector, see ggplot2 tutorial for the shape meaning.}

\item{\code{...}}{paremeters pass to geom_point.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_taxa_roles(roles_color_background = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-subset_network"></a>}}
\if{latex}{\out{\hypertarget{method-subset_network}{}}}
\subsection{Method \code{subset_network()}}{
Subset of the network.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$subset_network(node = NULL, edge = NULL, rm_single = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{node}}{default NULL; provide the node names that you want to use in the sub-network.}

\item{\code{edge}}{default NULL; provide the edge name needed; must be one of "+" or "-".}

\item{\code{rm_single}}{default TRUE; whether remove the nodes without any edge in the sub-network.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new network
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$subset_network(node = t1$res_node_table \%>\% base::subset(module == "M1") \%>\% 
  rownames, rm_single = TRUE)
# return a sub network that contains all nodes of module M1
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_powerlaw"></a>}}
\if{latex}{\out{\hypertarget{method-cal_powerlaw}{}}}
\subsection{Method \code{cal_powerlaw()}}{
Fit degrees to a power law distribution. First, perform a bootstrapping hypothesis test to determine whether degrees follow a power law distribution.
If the distribution follows power law, then fit degrees to power law distribution and return the parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$cal_powerlaw(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{paremeters pass to fit_power_law function in igraph package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_powerlaw_p and res_powerlaw_fit; see bootstrap_p function in poweRlaw package for the bootstrapping p value details;
  see fit_power_law function in igraph package for the power law fit return details.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_powerlaw()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_comm"></a>}}
\if{latex}{\out{\hypertarget{method-trans_comm}{}}}
\subsection{Method \code{trans_comm()}}{
Transform classifed features to community-like microtable object for further analysis, such as module-taxa table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$trans_comm(use_col = "module", abundance = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_col}}{default "module"; which column to use as the 'community'; must be one of the name of res_node_table from function get_node_table.}

\item{\code{abundance}}{default TRUE; whether sum abundance of taxa. TRUE: sum the abundance for a taxon across all samples; 
FALSE: sum the frequency for a taxon across all samples.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{\link{microtable}} class.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t2 <- t1$trans_comm(use_col = "module")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_network object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_network$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
