% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmpoutput.R
\name{summary.cmpoutput}
\alias{summary.cmpoutput}
\title{Summary method for comparison of an output}
\usage{
\method{summary}{cmpoutput}(object, ...)
}
\arguments{
\item{object}{Object of class \code{cmpoutput}.}

\item{...}{Currently ignored.}
}
\value{
A list with the following components:
\describe{
 \item{output.name}{Output name.}
 \item{num.pcs}{Number of principal components which explain \code{var.exp}
       percentage of variance.}
 \item{var.exp}{Minimum percentage of variance which must be explained by the
       number of principal components used for the MANOVA test.}
 \item{manova.pvals}{\emph{P}-value of the MANOVA test.}
 \item{parametric.test}{Name of the used parametric test.}
 \item{parametric.pvals}{Vector of $p$-values returned by applying the
       parametric test to each principal component.}
 \item{parametric.pvals.adjusted}{Vector of $p$-values returned by applying
       the parametric test to each principal component, adjusted with the
       weighted Bonferroni procedure, percentage of explained variance used
       as weight.}
 \item{nonparametric.test}{Name of the used non-parametric test.}
 \item{nonparametric.pvals}{Vector of $p$-values returned by applying the
       non-parametric test to each principal component.}
 \item{nonparametric.pvals.adjusted}{Vector of $p$-values returned by
       applying the non-parametric test to each principal component, adjusted
       with the weighted Bonferroni procedure, percentage of explained
       variance used as weight.}
}
}
\description{
Summary method for objects of class \code{cmpoutput}.
}
\examples{

# Comparing the concatenated output of the pphpc_noshuff dataset, which
# contains simulation output data from two implementations of the PPHPC model
# executed with a minor implementation difference.

summary(
  cmpoutput("All", 0.6, pphpc_noshuff$data[["All"]], pphpc_noshuff$obs_lvls)
)

}
