% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_many_wqs.R
\name{do.many.wqs}
\alias{do.many.wqs}
\title{Performing Many WQS Regressions}
\usage{
do.many.wqs(y, X.imputed, Z = NULL, ...)
}
\arguments{
\item{y}{Outcome: numeric vector or factor. Assumed to be complete, and missing outcomes are ignored. Assumed to follow an exponential family distribution given in \code{family}.}

\item{X.imputed}{Array of complete components with n subjects and C components and K imputations. Must be complete.}

\item{Z}{Any covariates used. Ideally, a numeric matrix, but Z can be a factor, vector or data-frame. Assumed to be complete; observations with missing covariate values are ignored with a warning printed. If none, enter NULL.}

\item{...}{Additional arguments passed to \code{estimate.wqs}, but the arguments y, X, Z, and place.bdls.Q1 have no effect.}
}
\value{
Returns a list with elements that consist of matrix and list versions of \code{estimate.wqs()} output: \itemize{
\item call: the function call, processed by \pkg{rlist}.
\item C:  the number of chemicals in mixture, number of columns in X.
\item n: the sample size.
   \item wqs.imputed.estimates: Array with rows = # of parameters, 2 columns = mean and standard deviation, and 3rd dimension = K.
    \item AIC: The overall fit of WQS models taken as the mean AIC and standard error across all imputation models. Saved as a character element.  Calling wqs.fit allows us to see all models.
    \item train.index: Observations that are selected to train the data in the last WQS model.
    \item q.train: Vector of quantiles used in training data from the last WQS model
    \item train.comparison: A list of data-frames that compares the training and validation dataset for all WQS models.
    \item initial: Matrix with K columns that contains the initial values used for each WQS analysis.
    \item wqs.train.estimates: Data-frame with rows = B. Summarizes statistics from nonlinear regression in the training datasets of all analyses: \describe{
     \item{beta1}{estimate using solnp}
     \item{beta1_glm, SE_beta1, test_stat, pvalue}{estimates of WQS parameter in model using glm2.}
     \item{convergence}{whether or not the samples have converged}
     \item{weight estimates}{estimates of weight for each bootstrap.}
     \item{imputed}{A number indicating the completed dataset used in WQS analysis.}
     }
     \item wqs.fit: A list (length = K) of glm2 objects of the WQS model fit to validation data. These are all the WQS estimates for all analyses. See \code{\link[glm2]{glm2}}.
     }
}
\description{
Second Stage of Multiple Imputation:  In order to analyze a complete imputed chemical array (\code{X.imputed}), _n_ subjects by _C_ chemicals by _K_ imputations) via weighted quantile sum regression, \code{do.many.wqs}() repeatedly performs the same WQS analysis on each imputed dataset. It repeatedly executes the \code{\link{estimate.wqs}}() function.
}
\note{
Note #1: We only impute the missing values of the components, X. Any missing data in the outcome and covariates are removed and ignored.

 Note #2: No seed is set in this function. Because bootstraps and splitting is random,  a seed should be set before every use.

 Note #3: If there is one imputed dataset, use the \code{\link{estimate.wqs}} function as \code{do.many.wqs} is not necessary.
}
\examples{
data("simdata87")
# Create 2 multiple imputed datasets using bootstrapping, but only use first 2 chemicals.
set.seed(23234)
l <- impute.boot(
  X = simdata87$X.bdl[, 1:2], DL = simdata87$DL[1:2],
  Z = simdata87$Z.sim[, 1], K = 2
)
# Perform WQS regression on each imputed dataset
set.seed(50679)
bayes.wqs <- do.many.wqs(
  y = simdata87$y.scenario, X.imputed = l$X.imputed,
  Z = simdata87$Z.sim,
  B = 10, family = "binomial"
)
bayes.wqs$wqs.imputed.estimates



# #' @importFrom scales ordinal
}
\seealso{
Other wqs: 
\code{\link{analyze.individually}()},
\code{\link{coef.wqs}()},
\code{\link{estimate.wqs.formula}()},
\code{\link{estimate.wqs}()},
\code{\link{make.quantile.matrix}()},
\code{\link{plot.wqs}()},
\code{\link{print.wqs}()}
}
\concept{wqs}
\keyword{wqs}
