% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mHR2_tvc.R
\name{mHR2.tvc}
\alias{mHR2.tvc}
\title{Cox regression for a bivariate outcome with time-varying covariates}
\usage{
mHR2.tvc(Y1, Y2, Delta1, Delta2, ids, X)
}
\arguments{
\item{Y1, Y2}{Vectors of event times (continuous).}

\item{Delta1, Delta2}{Vectors of censoring indicators (1=event,
0=censored).}

\item{ids}{Vector of ID numbers. It is used to map the values of
the time-varying covariates back to the original
Y1/Y2/Delta1/Delta2 values. See Details.}

\item{X}{Matrix of covariates (continuous or binary). See Details
for the proper format of this matrix.}
}
\value{
A list containing the following elements:
\describe{
\item{beta10, beta01, beta11:}{Regression coefficient estimates}
}
}
\description{
Fits a semiparametric Cox regression model for a bivariate
outcome with time-varying covariates. Currently only the regression
coefficients are computed.
}
\section{Details}{

X must be a matrix with at least four columns. The first column
contains the ID numbers. Each ID number in this column must map
to a unique element of the ids vector. The second and third columns
consists of time points for T1 and T2, respectively. They specify
the time points at which the covariates take on the specified
value(s). The remaining columns represent the values
of the covariates on the specified time interval. For example,
if we define
X.tv <- matrix(c(1001, 1001, 0, 0, 0, 5, 1, 2), nrow=2)
then, for the observation with ID number 1001, then when T1=0, the
time-varying covariate has a value of 1 on when T2 is in [0,5) and a
value of 2 when T2 is in [5,Inf). Note that the values of the
time-varying covariates must be specified for when T1=0 (or T2=0)
in order to compute beta10 and beta01. If a value of a covariate is
constant when T1=0 or T2=0, that covariate will be dropped when
computing beta10 or beta01.

Support for time-varying covariates is experimental and has not
been tested extensively. Use this function at your own risk.
}

\examples{
x <- genClaytonReg(250, 2, 0.5, 1, 1, 0, log(2), 0, 5, 5)
x.tv <- tvc.example(x$Y1, x$Y2, x$Delta1, x$Delta2, x$X)
\donttest{x.mHR2 <- mHR2.tvc(x$Y1, x$Y2, x$Delta1, x$Delta2,
x.tv$ids, x.tv$X.tv)}
}
\references{
Prentice, R., Zhao, S. "The statistical analysis of multivariate
failure time data: A marginal modeling approach", CRC Press (2019).
Prentice, R., Zhao, S. "Regression models and multivariate life tables",
Journal of the American Statistical Association (2020) In press.
}
\seealso{
\code{\link{mHR2}}
}
