% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgsub.R
\name{mgsub}
\alias{mgsub}
\title{Takes a list of conversions and applies it simultaneously to a string}
\usage{
mgsub(string, conversions = list(), ...)
}
\arguments{
\item{string}{a character vector where replacements are sought}

\item{conversions}{named list of conversions to apply}

\item{...}{arguments to pass to gregexpr/sub}
}
\value{
Converted string.
}
\description{
Takes a list of conversions and applies it simultaneously to a string
}
\examples{
mgsub("hey, ho",list("hey"="ho","ho"="hey"))
mgsub("developer",list("e" ="p", "p" = "e"))
mgsub("The chemical Dopaziamine is fake",
      list("dopa(.*?) "="mega\\\\1 ","fake"="real"),
      ignore.case=TRUE)
}
