% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browser.R
\name{open_marker_in_mgi}
\alias{open_marker_in_mgi}
\title{Browse MGI markers online}
\usage{
open_marker_in_mgi(marker_id)
}
\arguments{
\item{marker_id}{A character vector. MGI accession identifiers.}
}
\value{
Returns \code{TRUE} if successful, or \code{FALSE} otherwise. But note that
this function is run for its side effect of launching the browser.
}
\description{
\code{\link[=open_marker_in_mgi]{open_marker_in_mgi()}} launches the web browser and opens a tab for each MGI
accession identifier on the Mouse Genome Informatics web interface:
\url{https://www.informatics.jax.org}.
}
\examples{
# Read about Acta1 (actin alpha 1, skeletal muscle) online.
open_marker_in_mgi("MGI:87902")

# `open_marker_in_mgi()` is vectorized, so you can open multiple pages.
# NB: think twice if you really need to open many tabs at once.
open_marker_in_mgi(c("MGI:87902", "MGI:87909"))

}
