% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generation_powers.R
\name{generate_powers_fp}
\alias{generate_powers_fp}
\alias{generate_powers_acd}
\title{Function that generates a matrix of FP powers for any degree}
\usage{
generate_powers_fp(degree = NULL, powers = NULL)

generate_powers_acd(degree = NULL, powers = NULL)
}
\arguments{
\item{degree}{The degree of fractional polynomial. For example,
degree = 1 is FP1 and returns 8 powers; degree 2 is FP2 and
returns 36 pairs of powers; degree 3 is FP3 and returns 120
triples of powers, and so on. If the ACD transformation is used,
this degree is assumed to be 2.}

\item{powers}{the set of allowed powers for the fractional polynomials.
Default is \code{NULL} and the set \eqn{(-2, -1, -0.5, 0, 0.5, 1, 2, 3)} is used.}
}
\value{
A matrix of powers with degree columns and rows depending on the \code{degree}.
For ACD powers always a matrix with two columns. For normal fps each row
will be sorted in increasing order (in alignment with
how \code{\link[=transform_vector_fp]{transform_vector_fp()}} processes the data).
}
\description{
Function that generates a matrix of FP powers for any degree
}
\details{
For FP powers, this function returns all combinations of the powers of
length \code{degree}, that is all pairs in which each entry is taken from the
set \code{powers}, but no pair is repeated (i.e. the order of the entries does
not matter).
Thus, for the default set of powers and degree 2, this function returns
36 combinations.

For ACD powers, this function simply returns all possible tuples of
powers of length n.
Thus, for the default set of powers, this function returns 8 possible
powers, and for degree 2 it returns 64 pairs of powers. Higher degrees
are not supported by the function. In case that \code{degree = 0} or \code{degree = 1},
the first column of the matrix representing untransformed data are set to
\code{NA} to indicate that the normal data do not play a role. Higher degrees
than two are not supported.
}
\section{Functions}{
\itemize{
\item \code{generate_powers_acd()}: Function to generate acd powers.

}}
\examples{
powx <- c(-2, -1, -0.5, 0, 0.5, 1, 2, 3)
generate_powers_fp(degree = 2, powers = powx)
generate_powers_acd(degree = 2, powers = powx)

}
