% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.based.R
\name{model.based}
\alias{model.based}
\alias{model.based.default}
\alias{model.based.formula}
\title{Decision Tree Model Based Meta-features}
\usage{
model.based(...)

\method{model.based}{default}(x, y, features = "all",
  summary = c("mean", "sd"), ...)

\method{model.based}{formula}(formula, data, features = "all",
  summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Further arguments passed to the summarization functions.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.}

\item{summary}{A list of summarization functions or empty for all values. See
\link{post.processing} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.
The details section describes the valid values for this group.}
}
\value{
A list named by the requested meta-features.
}
\description{
Decision Tree (DT) Model Based meta-features are the measures designed to
extract characteristics of a DT model induced from a dataset.
}
\details{
The following features are allowed for this method:
 \describe{
   \item{"leaves"}{Number of leaves of the DT model.}
   \item{"leavesBranch"}{Size of branches, which consists in the level of all
   leaves of the DT model (multi-valued).}
   \item{"leavesCorrob"}{Leaves corroboration, which is the proportion of
   examples that belong to each leaf of the DT model (multi-valued).}
   \item{"leavesHomo"}{Homogeneity, which is the number of leaves divided by 
   the structural shape of the DT model (multi-valued).}
   \item{"leavesPerClass"}{Leaves per class, which is the proportion of 
   leaves of the DT model associated with each class (multi-valued).}
   \item{"nodes"}{Number of nodes of the DT model.}
   \item{"nodesPerAttr"}{Ratio of the number of nodes of the DT model per the
   number of attributes.}
   \item{"nodesPerInst"}{Ratio of the number of nodes of the DT model per the
   number of instances.}
   \item{"nodesPerLevel"}{Number of nodes of the DT model per level 
   (multi-valued).}
   \item{"nodesRepeated"}{Repeated nodes, which is the number of repeated
   attributes that appear in the DT model (multi-valued).}
   \item{"treeDepth"}{Tree depth, which is the level of all tree nodes and 
   leaves of the DT model (multi-valued).}
   \item{"treeImbalance"}{Tree imbalance (multi-valued).}
   \item{"treeShape"}{Tree shape, which is the probability of arrive in each 
   leaf given a random walk. We call this as the structural shape of the DT 
   model (multi-valued).}
   \item{"varImportance"}{Variable importance. It is calculated using the 
   Gini index to estimate the amount of information used in the DT model 
   (multi-valued).}
 }
}
\examples{
## Extract all meta-features using formula
model.based(Species ~ ., iris)

## Extract some meta-features
model.based(iris[1:4], iris[5], c("nodes", "leaves", "treeShape"))

## Use another summarization function
model.based(Species ~ ., iris, summary=c("min", "median", "max"))
}
\references{
Hilan Bensusan, Christophe Giraud-Carrier, and Claire Kennedy. A 
 higher-order approach to meta-learning. In 10th International Conference 
 Inductive Logic Programming (ILP), pages 33 - 42, 2000.

 Yonghong Peng, Peter A. Flach, Carlos Soares, and Pavel Brazdil. Improved 
 dataset characterization for meta-learning. In 5th International Conference 
 on Discovery Science (DS), pages 141 - 152, 2002.
}
\seealso{
Other meta-features: \code{\link{clustering}},
  \code{\link{complexity}}, \code{\link{concept}},
  \code{\link{general}}, \code{\link{infotheo}},
  \code{\link{itemset}}, \code{\link{landmarking}},
  \code{\link{relative}}, \code{\link{statistical}}
}
\concept{meta-features}
