% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{estimate_mfbvar}
\alias{estimate_mfbvar}
\title{Mixed-frequency Bayesian VAR}
\usage{
estimate_mfbvar(mfbvar_prior = NULL, prior_type, ...)
}
\arguments{
\item{mfbvar_prior}{a \code{mfbvar_prior} object}

\item{prior_type}{either \code{"ss"} (steady-state prior) or \code{"minn"} (Minnesota prior)}

\item{...}{additional arguments to \code{update_prior} (if \code{mfbvar_prior} is \code{NULL}, the arguments are passed on to \code{set_prior})}
}
\value{
an object of class \code{mfbvar} and \code{mfbvar_ss}/\code{mfbvar_minn} containing posterior quantities as well as the prior object

The prior values used are carried forward and returned with \code{NULL} if not used/existing. New components are:
\item{Pi}{Array of dynamic coefficient matrices (\eqn{\Pi}) from the main chain; \code{Pi[,, r]} is the \code{r}th draw}
\item{Sigma}{Array of covariance matrices (\eqn{\Sigma}) from the main chain; \code{Sigma[,, r]} is the \code{r}th draw}
\item{psi}{Matrix of steady-state parameter vectors (\eqn{\psi}) from the main chain; \code{psi[r,]} is the \code{r}th draw}
\item{Z}{Array of monthly process (\eqn{Z}) matrices from the main chain; \code{Z[,, r]} is the \code{r}th draw}
\item{roots}{The maximum eigenvalue of the lag polynomial (if \code{check_roots = TRUE})}
\item{num_tries}{The number of attempts for drawing a stationary \eqn{\Pi} (only relevant if \code{prior_type = "ss"})}
\item{Z_fcst}{Array of monthly forecasts from the main chain; \code{Z_fcst[,, r]} is the \code{r}th forecast. The first \code{n_lags}
rows are taken from the data to offer a bridge between observations and forecasts and for computing nowcasts (i.e. with ragged edges).}
\item{smoothed_Z}{The smoothed estimates (if \code{smooth_state = TRUE})}
}
\description{
The main function for estimating a mixed-frequency BVAR.
}
\examples{
prior_obj <- set_prior(Y = mf_sweden, freq = c(rep("m", 4), "q"),
                       n_lags = 4, n_burnin = 20, n_reps = 20)
mod_minn <- estimate_mfbvar(prior_obj, prior_type = "minn")
}
\references{
Schorfheide, F., & Song, D. (2015) Real-Time Forecasting With a Mixed-Frequency VAR. \emph{Journal of Business & Economic Statistics}, 33(3), 366--380. \url{http://dx.doi.org/10.1080/07350015.2014.954707}\cr
Ankargren, S., Unosson, M., & Yang, Y. (2018) A Mixed-Frequency Bayesian Vector Autoregression with a Steady-State Prior. Working Paper, Department of Statistics, Uppsala University No. 2018:3.
}
\seealso{
\code{\link{set_prior}}, \code{\link{update_prior}}, \code{\link{predict.mfbvar}}, \code{\link{plot.mfbvar_minn}},
\code{\link{plot.mfbvar_ss}}, \code{\link{summary.mfbvar_minn}}, \code{\link{summary.mfbvar_ss}}
}
