% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_mfgarch.R
\name{simulate_mfgarch_rv_dependent}
\alias{simulate_mfgarch_rv_dependent}
\title{Simulate a GARCH-MIDAS similar to Wang/Ghysels with lagged RVol as covariate}
\usage{
simulate_mfgarch_rv_dependent(
  n.days,
  mu,
  alpha,
  beta,
  gamma,
  m,
  theta,
  w1 = 1,
  w2,
  K,
  n.intraday = 288,
  low.freq = 1,
  rvol = FALSE
)
}
\arguments{
\item{n.days}{number of days}

\item{mu}{mu}

\item{alpha}{alpha}

\item{beta}{beta}

\item{gamma}{gamma}

\item{m}{m}

\item{theta}{theta}

\item{w1}{w1}

\item{w2}{w2}

\item{K}{K}

\item{n.intraday}{number of maximum intraday returns, default 288}

\item{low.freq}{number of days per low frequency}

\item{rvol}{if TRUE, the square root of the realized variance is used as a covariate}
}
\description{
Simulate a GARCH-MIDAS similar to Wang/Ghysels with lagged RVol as covariate
}
\examples{
simulate_mfgarch_rv_dependent(n.days = 2200, mu = 0, alpha = 0.06, beta = 0.92, gamma = 0, m = 0,
  theta = 0.1, w1 = 1, w2 = 3, K = 3, low.freq = 22)
}
