% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dutils.R
\name{drelevel}
\alias{drelevel}
\alias{dlevels}
\alias{dlevel}
\alias{dlev}
\alias{drelev}
\alias{dlev<-}
\alias{dlevel<-}
\alias{drelev<-}
\alias{drelevel<-}
\alias{dfactor}
\alias{dfactor<-}
\alias{dnumeric}
\alias{dnumeric<-}
\title{relev levels for data frames}
\usage{
drelevel(data, y = NULL, x = NULL, ref = NULL, newlevels = NULL,
  regex = mets.options()$regex, sep = NULL, overwrite = FALSE, ...)
}
\arguments{
\item{data}{if x is formula or names for data frame then data frame is needed.}

\item{y}{name of variable, or fomula, or names of variables on data frame.}

\item{x}{name of variable, or fomula, or names of variables on data frame.}

\item{ref}{new reference variable}

\item{newlevels}{to combine levels of factor in data frame}

\item{regex}{for regular expressions.}

\item{sep}{seperator for naming of cut names.}

\item{overwrite}{to overwrite variable}

\item{...}{Optional additional arguments}
}
\description{
levels shows levels for variables in data frame, relevel relevels a factor in data.frame
}
\examples{

data(mena)
dstr(mena)
dfactor(mena)  <- ~twinnum
dnumeric(mena) <- ~twinnum.f

dstr(mena)

mena2 <- drelevel(mena,"cohort",ref="(1980,1982]")
mena2 <- drelevel(mena,~cohort,ref="(1980,1982]")
mena2 <- drelevel(mena,cohortII~cohort,ref="(1980,1982]")
dlevels(mena)
dlevels(mena2)
drelevel(mena,ref="(1975,1977]")  <-  ~cohort
drelevel(mena,ref="(1980,1982]")  <-  ~cohort
dlevels(mena,"coh*")
dtable(mena,"coh*",level=1)

### level 1 of zyg as baseline for new variable
drelevel(mena,ref=1) <- ~zyg
drelevel(mena,ref=c("DZ","[1973,1975]")) <- ~ zyg+cohort
drelevel(mena,ref=c("DZ","[1973,1975]")) <- zygdz+cohort.early~ zyg+cohort
### level 2 of zyg and cohort as baseline for new variables
drelevel(mena,ref=2) <- ~ zyg+cohort
dlevels(mena)

##################### combining factor levels with newlevels argument

dcut(mena,labels=c("I","II","III","IV")) <- cat4~agemena
dlevels(drelevel(mena,~cat4,newlevels=1:3))
dlevels(drelevel(mena,ncat4~cat4,newlevels=3:2))
drelevel(mena,newlevels=3:2) <- ncat4~cat4
dlevels(mena)

dlevels(drelevel(mena,nca4~cat4,newlevels=list(c(1,4),2:3)))

drelevel(mena,newlevels=list(c(1,4),2:3)) <- nca4..2 ~ cat4
dlevels(mena)

drelevel(mena,newlevels=list("I-III"=c("I","II","III"),"IV"="IV")) <- nca4..3 ~ cat4
dlevels(mena)

drelevel(mena,newlevels=list("I-III"=c("I","II","III"))) <- nca4..4 ~ cat4
dlevels(mena)

drelevel(mena,newlevels=list(group1=c("I","II","III"))) <- nca4..5 ~ cat4
dlevels(mena)

drelevel(mena,newlevels=list(g1=c("I","II","III"),g2="IV")) <- nca4..6 ~ cat4
dlevels(mena)

}
\author{
Klaus K. Holst and Thomas Scheike
}
