% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dutils.R
\name{dcut}
\alias{dcut}
\alias{dcut<-}
\alias{dunique}
\alias{drm}
\alias{drm<-}
\alias{dnames}
\alias{dnames<-}
\alias{drename}
\alias{drename<-}
\alias{dkeep}
\alias{dkeep<-}
\alias{ddrop}
\alias{ddrop<-}
\title{Cutting, sorting, rm (removing), rename for data frames}
\usage{
dcut(data, y = NULL, x = NULL, breaks = 4, probs = NULL, equi = FALSE,
  regex = mets.options()$regex, sep = NULL, na.rm = TRUE, labels = NULL,
  all = FALSE, ...)
}
\arguments{
\item{data}{if x is formula or names for data frame then data frame is needed.}

\item{y}{name of variable, or fomula, or names of variables on data frame.}

\item{x}{name of variable, or fomula, or names of variables on data frame.}

\item{breaks}{number of breaks, for variables or vector of break points,}

\item{probs}{groups defined from quantiles}

\item{equi}{for equi-spaced breaks}

\item{regex}{for regular expressions.}

\item{sep}{seperator for naming of cut names.}

\item{na.rm}{to remove NA for grouping variables.}

\item{labels}{to use for cut groups}

\item{all}{to do all variables, even when breaks are not unique}

\item{...}{Optional additional arguments}
}
\description{
Cut variables, if breaks are given these are used, otherwise cuts into 
using group size given by probs, or equispace groups on range. Default 
is equally sized groups if possible
}
\examples{
data("sTRACE",package="timereg")
sTRACE$age2 <- sTRACE$age^2
sTRACE$age3 <- sTRACE$age^3

mm <- dcut(sTRACE,~age+wmi)
head(mm)

mm <- dcut(sTRACE,catage4+wmi4~age+wmi)
head(mm)

mm <- dcut(sTRACE,~age+wmi,breaks=c(2,4))
head(mm)

mm <- dcut(sTRACE,c("age","wmi"))
head(mm)

mm <- dcut(sTRACE,~.)
head(mm)

mm <- dcut(sTRACE,c("age","wmi"),breaks=c(2,4))
head(mm)

gx <- dcut(sTRACE$age)
head(gx)


## Removes all cuts variables with these names wildcards
mm1 <- drm(mm,c("*.2","*.4"))
head(mm1)

## wildcards, for age, age2, age4 and wmi
head(dcut(mm,c("a*","?m*")))

## with direct asignment
drm(mm) <- c("*.2","*.4")
head(mm)

dcut(mm) <- c("age","*m*")
dcut(mm) <- ageg1+wmig1~age+wmi
head(mm)

############################
## renaming
############################

head(mm)
drename(mm, ~Age+Wmi) <- c("wmi","age")
head(mm)
mm1 <- mm

## all names to lower
drename(mm1) <- ~.
head(mm1)

## A* to lower
mm2 <-  drename(mm,c("A*","W*"))
head(mm2)
drename(mm) <- "A*"
head(mm)

dd <- data.frame(A_1=1:2,B_1=1:2)
funn <- function(x) gsub("_",".",x)
drename(dd) <- ~.
drename(dd,fun=funn) <- ~.
names(dd)
}
\author{
Klaus K. Holst and Thomas Scheike
}
