% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent.marginal.R
\name{count.history}
\alias{count.history}
\title{Counts the number of previous events of two types for recurrent events processes}
\usage{
count.history(data, status = "status", id = "id", types = 1:2,
  names.count = "Count", lag = TRUE)
}
\arguments{
\item{data}{data-frame}

\item{status}{name of status}

\item{id}{id}

\item{types}{types of the events (code) related to status}

\item{names.count}{name of Counts, for example Count1 Count2 when types=c(1,2)}

\item{lag}{if true counts previously observed, and if lag=FALSE counts up to know}
}
\description{
Counts the number of previous events of two types for recurrent events processes
}
\examples{
########################################
## getting some rates to mimick 
########################################

data(base1cumhaz)
data(base4cumhaz)
data(drcumhaz)
dr <- drcumhaz
base1 <- base1cumhaz
base4 <- base4cumhaz

######################################################################
### simulating simple model that mimicks data 
### now with two event types and second type has same rate as death rate
######################################################################

rr <- simRecurrentII(1000,base1,dr,death.cumhaz=base4)
rr <-  count.history(rr)
dtable(rr,~"Count*"+status,level=1)

}
\author{
Thomas Scheike
}
