% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{phreg}
\alias{phreg}
\alias{phreg.par}
\alias{robust.phreg}
\title{Fast Cox PH regression}
\usage{
phreg(formula, data, offset = NULL, weights = NULL, ...)
}
\arguments{
\item{formula}{formula with 'Surv' outcome (see \code{coxph})}

\item{data}{data frame}

\item{offset}{offsets for cox model}

\item{weights}{weights for Cox score equations}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Fast Cox PH regression
Robust variance is default variance with the summary.
}
\examples{
data(TRACE)
dcut(TRACE) <- ~.
out1 <- phreg(Surv(time,status==9)~vf+chf+strata(wmicat.4),data=TRACE)
## tracesim <- timereg::sim.cox(out1,1000)
## sout1 <- phreg(Surv(time,status==1)~vf+chf+strata(wmicat.4),data=tracesim)
## robust standard errors default 
summary(out1)

par(mfrow=c(1,3))
basehazplot.phreg(out1)
## basehazplot.phreg(sout1,se=TRUE)

## computing robust variance for baseline
rob1 <- robust.phreg(out1)
basehazplot.phreg(rob1,se=TRUE,robust=TRUE)

## making iid decomposition of regression parameters
betaiiid <- iid(out1)

}
\author{
Klaus K. Holst, Thomas Scheike
}
